/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.compile;

import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.core.GameStateRegistry;
import com.jozufozu.flywheel.core.shader.ProgramSpec;
import com.jozufozu.flywheel.core.shader.StateSnapshot;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public final class ProgramContext {
    public final ProgramSpec spec;
    public final float alphaDiscard;
    public final VertexType vertexType;
    public final StateSnapshot ctx;

    public static ProgramContext create(ResourceLocation programName, VertexType vertexType, @Nullable RenderLayer layer) {
        ProgramSpec spec = Backend.getSpec(programName);
        if (spec == null) {
            throw new NullPointerException("Cannot compile shader because '" + programName + "' is not recognized.");
        }
        return new ProgramContext(spec, ProgramContext.getAlphaDiscard(layer), vertexType, GameStateRegistry.takeSnapshot());
    }

    public static float getAlphaDiscard(@Nullable RenderLayer layer) {
        return layer == RenderLayer.CUTOUT ? 0.1f : 0.0f;
    }

    public ProgramContext(ProgramSpec spec, float alphaDiscard, VertexType vertexType, StateSnapshot ctx) {
        this.spec = spec;
        this.alphaDiscard = alphaDiscard;
        this.vertexType = vertexType;
        this.ctx = ctx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramContext that = (ProgramContext)o;
        return this.spec == that.spec && this.vertexType == that.vertexType && this.ctx.equals(that.ctx) && Float.floatToIntBits(this.alphaDiscard) == Float.floatToIntBits(that.alphaDiscard);
    }

    public int hashCode() {
        return Objects.hash(this.spec, Float.valueOf(this.alphaDiscard), this.vertexType, this.ctx);
    }

    public String toString() {
        return "ProgramContext{spec=" + this.spec + ", alphaDiscard=" + this.alphaDiscard + ", vertexType=" + this.vertexType + ", ctx=" + this.ctx + "}";
    }
}

