/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.item;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.culinaryconstruct.api.CulinaryConstructApi;
import top.theillusivec4.culinaryconstruct.common.util.CulinaryNBTHelper;

public class CulinaryItemBase
extends Item {
    public static final Random RANDOM = new Random();

    public CulinaryItemBase() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41489_(new FoodProperties.Builder().m_38767_()));
    }

    protected static void generateCreativeNBT(ItemStack sub) {
        CulinaryNBTHelper.setSize(sub, 5);
        CulinaryNBTHelper.setIngredientsList(sub, (NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42686_), new ItemStack((ItemLike)Items.f_42686_), new ItemStack((ItemLike)Items.f_42686_), new ItemStack((ItemLike)Items.f_42686_), new ItemStack((ItemLike)Items.f_42686_)}));
        CulinaryNBTHelper.setFoodAmount(sub, 20);
        CulinaryNBTHelper.setSaturation(sub, 1.0f);
        CulinaryNBTHelper.setQuality(sub, 4);
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level worldIn, @Nonnull LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int food = CulinaryNBTHelper.getFoodAmount(stack);
            float saturation = CulinaryNBTHelper.getSaturation(stack);
            player.m_36324_().m_38707_(food, saturation);
            ArrayList<ItemStack> consumed = new ArrayList<ItemStack>((Collection<ItemStack>)CulinaryNBTHelper.getIngredientsList(stack));
            consumed.add(CulinaryNBTHelper.getBase(stack));
            consumed.forEach(itemstack -> {
                if (!itemstack.m_41619_()) {
                    CulinaryConstructApi.getCulinaryIngredient(itemstack).ifPresent(culinary -> {
                        culinary.onEaten(player);
                        culinary.getEffects().forEach(effect -> {
                            if (RANDOM.nextFloat() < ((Float)effect.getRight()).floatValue()) {
                                player.m_7292_((MobEffectInstance)effect.getLeft());
                            }
                        });
                    });
                    FoodProperties foodie = itemstack.m_41720_().m_41473_();
                    if (foodie != null) {
                        foodie.m_38749_().forEach(effect -> {
                            if (RANDOM.nextFloat() < ((Float)effect.getSecond()).floatValue()) {
                                player.m_7292_((MobEffectInstance)effect.getFirst());
                            }
                        });
                    }
                }
            });
        }
        return livingEntity.m_5584_(worldIn, stack);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        StringBuilder fullName = new StringBuilder();
        NonNullList<ItemStack> ingredients = CulinaryNBTHelper.getIngredientsList(stack);
        if (!ingredients.isEmpty()) {
            Map<Item, Long> countMap = ingredients.stream().collect(Collectors.groupingBy(ItemStack::m_41720_, Collectors.counting()));
            ArrayList names = new ArrayList();
            countMap.forEach((item, count) -> {
                StringBuilder builder = new StringBuilder();
                if (count > 1L) {
                    TranslatableComponent trans = new TranslatableComponent("tooltip.culinaryconstruct.count." + count);
                    builder.append(trans.getString());
                    builder.append(" ");
                }
                builder.append(new TranslatableComponent(item.m_5524_()).getString());
                names.add(builder.toString());
            });
            fullName.append(new TranslatableComponent("tooltip.culinaryconstruct.list." + names.size(), names.toArray()).getString());
        }
        fullName.append(" ");
        fullName.append(new TranslatableComponent(this.m_5671_(stack)).getString());
        return new TextComponent(fullName.toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        ItemStack base = CulinaryNBTHelper.getBase(stack);
        int quality = CulinaryNBTHelper.getQuality(stack);
        tooltip.add((Component)new TranslatableComponent("tooltip.culinaryconstruct.quality." + quality).m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)new TranslatableComponent(base.m_41778_()).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TextComponent(""));
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344)) {
            NonNullList<ItemStack> ingredients = CulinaryNBTHelper.getIngredientsList(stack);
            tooltip.add((Component)new TranslatableComponent("tooltip.culinaryconstruct.ingredients.name").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.UNDERLINE));
            for (ItemStack ing : ingredients) {
                if (ing.m_41619_()) continue;
                tooltip.add((Component)new TranslatableComponent(ing.m_41778_()).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.culinaryconstruct.ingredients").m_130940_(ChatFormatting.GRAY));
        }
    }
}

