/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.StringUtils;
import top.theillusivec4.culinaryconstruct.api.CulinaryConstructApi;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;
import top.theillusivec4.culinaryconstruct.common.CulinaryConstructConfig;
import top.theillusivec4.culinaryconstruct.common.advancement.CraftFoodTrigger;
import top.theillusivec4.culinaryconstruct.common.blockentity.CulinaryStationBlockEntity;
import top.theillusivec4.culinaryconstruct.common.inventory.CulinaryCalculator;
import top.theillusivec4.culinaryconstruct.common.item.CulinaryItemBase;
import top.theillusivec4.culinaryconstruct.common.registry.CulinaryConstructRegistry;
import top.theillusivec4.culinaryconstruct.common.tag.CulinaryTags;

public class CulinaryStationContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess worldPosCallable;
    private ItemStackHandler base = new ItemStackHandler();
    private ItemStackHandler ingredients = new ItemStackHandler(5);
    private ItemStackHandler output = new ItemStackHandler();
    private String outputItemName;

    public CulinaryStationContainer(int windowId, Inventory playerInventory, FriendlyByteBuf unused) {
        this(windowId, playerInventory, ContainerLevelAccess.f_39287_, null);
    }

    public CulinaryStationContainer(int windowId, Inventory playerInventory, ContainerLevelAccess worldPosCallable, @Nullable BlockEntity tileEntity) {
        super(CulinaryConstructRegistry.CULINARY_STATION_CONTAINER, windowId);
        this.worldPosCallable = worldPosCallable;
        this.init(tileEntity);
        this.addFoodSlots();
        this.addPlayerSlots(playerInventory);
    }

    private void init(@Nullable BlockEntity tileEntity) {
        if (tileEntity instanceof CulinaryStationBlockEntity) {
            CulinaryStationBlockEntity te = (CulinaryStationBlockEntity)tileEntity;
            this.base = te.base;
            this.ingredients = te.ingredients;
            this.output = te.output;
        }
    }

    private void addFoodSlots() {
        this.m_38897_((Slot)new BaseSlot((IItemHandler)this.base, 0, 8, 44));
        for (int i = 0; i < this.ingredients.getSlots(); ++i) {
            this.m_38897_((Slot)new IngredientSlot((IItemHandler)this.ingredients, i, 44 + i * 18, 44));
        }
        this.m_38897_((Slot)new OutputSlot((IItemHandler)this.output, 0, 152, 44));
    }

    private void addPlayerSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 79 + row * 18));
            }
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.m_38897_(new Slot((Container)playerInventory, hotbar, 8 + hotbar * 18, 137));
        }
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return CulinaryStationContainer.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)CulinaryConstructRegistry.CULINARY_STATION);
    }

    public void updateOutput() {
        ItemStack baseStack = this.base.getStackInSlot(0);
        if (baseStack.m_41619_()) {
            this.resetOutput();
            return;
        }
        NonNullList ingredientsList = NonNullList.m_122779_();
        for (int i = 0; i < this.ingredients.getSlots(); ++i) {
            ItemStack stack = this.ingredients.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            ingredientsList.add((Object)copy);
        }
        if (ingredientsList.isEmpty()) {
            this.resetOutput();
            return;
        }
        ItemStack baseCopy = baseStack.m_41777_();
        baseCopy.m_41764_(1);
        CulinaryCalculator calculator = new CulinaryCalculator(baseCopy, (NonNullList<ItemStack>)ingredientsList);
        ItemStack result = calculator.getResult();
        if (result.m_41619_()) {
            this.resetOutput();
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.outputItemName)) {
            result.m_41787_();
        } else if (!this.outputItemName.equals(result.m_41786_().getString())) {
            result.m_41714_((Component)new TextComponent(this.outputItemName));
        }
        this.setOutput(result);
    }

    private void setOutput(ItemStack stack) {
        this.output.setStackInSlot(0, stack);
        this.m_38946_();
    }

    private void resetOutput() {
        ItemStack outputStack = this.output.getStackInSlot(0);
        if (!outputStack.m_41619_()) {
            this.output.setStackInSlot(0, ItemStack.f_41583_);
            this.m_38946_();
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 6) {
                if (!this.m_38903_(itemstack1, 7, 43, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 7 && index < 43 ? !this.m_38903_(itemstack1, 0, 1, false) && !this.m_38903_(itemstack1, 1, 6, false) : !this.m_38903_(itemstack1, 7, 43, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void updateItemName(String newName) {
        this.outputItemName = newName;
        this.updateOutput();
    }

    private class BaseSlot
    extends SlotItemHandler {
        public BaseSlot(IItemHandler handler, int index, int xPos, int yPos) {
            super(handler, index, xPos, yPos);
        }

        public void m_6654_() {
            CulinaryStationContainer.this.updateOutput();
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return CulinaryTags.BREAD.m_8110_((Object)stack.m_41720_()) || CulinaryTags.BOWL.m_8110_((Object)stack.m_41720_());
        }
    }

    private class IngredientSlot
    extends SlotItemHandler {
        public IngredientSlot(IItemHandler handler, int index, int xPos, int yPos) {
            super(handler, index, xPos, yPos);
        }

        public void m_6654_() {
            CulinaryStationContainer.this.updateOutput();
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            LazyOptional<ICulinaryIngredient> culinary = CulinaryConstructApi.getCulinaryIngredient(stack);
            return !(stack.m_41720_() instanceof CulinaryItemBase) && (stack.m_41720_().m_41472_() || culinary.map(ICulinaryIngredient::isValid).orElse(false) != false) && CulinaryConstructConfig.isValidIngredient(stack);
        }
    }

    private class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler handler, int index, int xPos, int yPos) {
            super(handler, index, xPos, yPos);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }

        public void m_6654_() {
            CulinaryStationContainer.this.updateOutput();
            CulinaryStationContainer.this.m_38946_();
        }

        public void m_142406_(Player playerEntity, @Nonnull ItemStack stack) {
            ItemStackHandler base;
            ItemStackHandler ingredients;
            if (!playerEntity.f_19853_.f_46443_) {
                CraftFoodTrigger.INSTANCE.trigger((ServerPlayer)playerEntity);
            }
            if ((ingredients = CulinaryStationContainer.this.ingredients) != null) {
                for (int i = 0; i < ingredients.getSlots(); ++i) {
                    ItemStack slot = ingredients.getStackInSlot(i);
                    if (slot.m_41619_()) continue;
                    boolean isPotion = slot.m_41720_() instanceof PotionItem;
                    boolean isSoup = slot.m_41720_() instanceof BowlFoodItem;
                    ItemStack container = slot.m_41720_().getContainerItem(slot);
                    slot.m_41774_(1);
                    if (container.m_41619_()) {
                        if (isPotion) {
                            container = new ItemStack((ItemLike)Items.f_42590_);
                        } else if (isSoup) {
                            container = new ItemStack((ItemLike)Items.f_42399_);
                        }
                    }
                    if (container.m_41619_()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)container);
                }
            }
            if ((base = CulinaryStationContainer.this.base) != null) {
                base.getStackInSlot(0).m_41774_(1);
            }
            CulinaryStationContainer.this.updateOutput();
        }
    }
}

