/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.culinaryconstruct.api.CulinaryConstructApi;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;
import top.theillusivec4.culinaryconstruct.common.CulinaryConstructConfig;
import top.theillusivec4.culinaryconstruct.common.registry.CulinaryConstructRegistry;
import top.theillusivec4.culinaryconstruct.common.tag.CulinaryTags;
import top.theillusivec4.culinaryconstruct.common.util.CulinaryNBTHelper;

public class CulinaryCalculator {
    private final NonNullList<ItemStack> ingredients;
    private final NonNullList<ItemStack> solids;
    private final List<ItemStack> processed = new ArrayList<ItemStack>();
    private final ItemStack base;
    private final List<Integer> liquidColors;
    private int food;
    private float saturation;
    private int complexity;

    public CulinaryCalculator(ItemStack baseIn, NonNullList<ItemStack> ingredientsIn) {
        this.base = baseIn;
        this.ingredients = ingredientsIn;
        this.solids = NonNullList.m_122779_();
        this.liquidColors = new ArrayList<Integer>();
    }

    public ItemStack getResult() {
        int maxFood;
        OutputType type;
        ArrayList<ItemStack> process = new ArrayList<ItemStack>((Collection<ItemStack>)this.ingredients);
        this.processed.clear();
        if (CulinaryTags.BREAD.m_8110_((Object)this.base.m_41720_())) {
            type = OutputType.SANDWICH;
            maxFood = CulinaryConstructConfig.maxFoodPerSandwich;
        } else if (CulinaryTags.BOWL.m_8110_((Object)this.base.m_41720_())) {
            type = OutputType.BOWL;
            maxFood = Integer.MAX_VALUE;
        } else {
            return ItemStack.f_41583_;
        }
        if (type == OutputType.SANDWICH) {
            process.add(this.base);
        }
        for (ItemStack stack : process) {
            if (stack.m_41619_() || this.processStack(stack)) continue;
            return ItemStack.f_41583_;
        }
        if (type == OutputType.SANDWICH && !this.liquidColors.isEmpty()) {
            return ItemStack.f_41583_;
        }
        if (this.saturation <= 0.0f || this.food <= 0) {
            return ItemStack.f_41583_;
        }
        this.saturation /= (float)this.food;
        int count = 1;
        if (type == OutputType.SANDWICH) {
            count = (int)Math.ceil((double)this.food / (double)maxFood);
        }
        this.food = (int)Math.ceil((double)this.food / (double)count);
        int quality = Mth.m_14045_((int)(this.complexity - this.getSize() / 2 + 1), (int)0, (int)4);
        this.saturation *= 1.0f + (float)(quality - 2) * 0.3f;
        ItemStack result = type == OutputType.SANDWICH ? new ItemStack((ItemLike)CulinaryConstructRegistry.SANDWICH) : new ItemStack((ItemLike)CulinaryConstructRegistry.FOOD_BOWL);
        CulinaryNBTHelper.setSize(result, this.getSize());
        CulinaryNBTHelper.setIngredientsList(result, this.ingredients);
        CulinaryNBTHelper.setFoodAmount(result, this.food);
        CulinaryNBTHelper.setSaturation(result, this.saturation);
        CulinaryNBTHelper.setQuality(result, quality);
        CulinaryNBTHelper.setBase(result, this.base);
        CulinaryNBTHelper.setSolids(result, this.solids);
        CulinaryNBTHelper.setSolidsSize(result, this.solids.size());
        if (!this.liquidColors.isEmpty() && type != OutputType.SANDWICH) {
            this.liquidColors.removeIf(Objects::isNull);
            CulinaryNBTHelper.setLiquids(result, this.liquidColors);
        }
        result.m_41764_(count);
        return result;
    }

    public boolean processStack(ItemStack stack) {
        Item item = stack.m_41720_();
        FoodProperties food = item.m_41473_();
        LazyOptional<ICulinaryIngredient> culinary = CulinaryConstructApi.getCulinaryIngredient(stack);
        int foodAmount = 0;
        float saturationAmount = 0.0f;
        boolean valid = true;
        if (culinary.isPresent()) {
            culinary.ifPresent(ingredient -> {
                if (ingredient.isLiquid()) {
                    this.liquidColors.add(ingredient.getLiquidColor());
                } else {
                    this.solids.add((Object)stack);
                }
            });
            valid = culinary.map(ICulinaryIngredient::isValid).orElse(true);
            foodAmount = culinary.map(ICulinaryIngredient::getFoodAmount).orElse(0);
            saturationAmount = culinary.map(ICulinaryIngredient::getSaturation).orElse(Float.valueOf(0.0f)).floatValue();
        } else if (food != null) {
            foodAmount = food.m_38744_();
            saturationAmount = food.m_38745_();
            this.solids.add((Object)stack);
        }
        if (!valid) {
            return false;
        }
        this.food += foodAmount;
        this.saturation += saturationAmount * (float)foodAmount;
        boolean unique = true;
        for (ItemStack existing : this.processed) {
            if (existing.m_41619_() || !ItemStack.m_41728_((ItemStack)existing, (ItemStack)stack)) continue;
            unique = false;
            break;
        }
        if (unique) {
            ++this.complexity;
        }
        this.processed.add(stack);
        return true;
    }

    public int getSize() {
        return this.ingredients.size();
    }

    static enum OutputType {
        SANDWICH,
        BOWL;

    }
}

