/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.CapabilityItemHandler;
import top.theillusivec4.culinaryconstruct.common.blockentity.CulinaryStationBlockEntity;
import top.theillusivec4.culinaryconstruct.common.inventory.CulinaryStationContainer;

public class CulinaryStationBlock
extends Block
implements EntityBlock {
    private static final Component CONTAINER_NAME = new TranslatableComponent("culinaryconstruct.culinary_container");

    public CulinaryStationBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.5f).m_60918_(SoundType.f_56736_));
        this.setRegistryName("culinaryconstruct:culinary_station");
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        player.m_5893_(state.m_60750_(worldIn, pos));
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof CulinaryStationBlockEntity) {
                CulinaryStationBlockEntity cte = (CulinaryStationBlockEntity)tileentity;
                NonNullList items = NonNullList.m_122779_();
                cte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(cap -> {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        items.add((Object)cap.getStackInSlot(i));
                    }
                });
                cte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST).ifPresent(cap -> {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        items.add((Object)cap.getStackInSlot(i));
                    }
                });
                Containers.m_19010_((Level)worldIn, (BlockPos)pos, (NonNullList)items);
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new CulinaryStationBlockEntity(pos, state);
    }

    public MenuProvider m_7246_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos) {
        return new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CulinaryStationContainer(windowId, playerInventory, ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos), worldIn.m_7702_(pos)), CONTAINER_NAME);
    }
}

