/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.mixin.AccessInputConstantsKey;
import com.blamejared.controlling.mixin.AccessKeyMapping;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class FreeKeysList
extends CustomList {
    private final KeyBindsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;
    List<KeyMapping> keyBindings;

    public FreeKeysList(KeyBindsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.f_93388_ = controls.f_96543_ + 45;
        this.f_93389_ = controls.f_96544_;
        this.f_93390_ = 43;
        this.f_93391_ = controls.f_96544_ - 80;
        this.f_93392_ = controls.f_96543_ + 45;
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.m_6702_().clear();
        this.allEntries = new ArrayList();
        this.keyBindings = Arrays.stream(this.mc.f_91066_.f_92059_).collect(Collectors.toList());
        this.recalculate();
    }

    public void recalculate() {
        this.m_6702_().clear();
        this.allEntries.clear();
        this.addEntry(new HeaderEntry("Available Keys"));
        AccessInputConstantsKey.getNAME_MAP().values().stream().filter(input -> !input.toString().startsWith("key.keyboard.world")).sorted(Comparator.comparing(o -> o.m_84875_().getString())).forEach(input -> {
            if (this.keyBindings.stream().noneMatch(keyBinding -> ((AccessKeyMapping)keyBinding).getKey().equals(input))) {
                int i = this.mc.f_91062_.m_92895_(input.m_84875_().getString());
                if (i > this.maxListLabelWidth) {
                    this.maxListLabelWidth = i;
                }
                this.addEntry(new InputEntry((InputConstants.Key)input));
            }
        });
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    public class HeaderEntry
    extends KeyBindsList.Entry {
        private final String text;

        public HeaderEntry(String text) {
            this.text = text;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        public void m_6311_(PoseStack stack, int slotIndex, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            GuiComponent.m_93215_((PoseStack)stack, (Font)FreeKeysList.this.mc.f_91062_, (Component)new TranslatableComponent("options.availableKeys"), (int)(Objects.requireNonNull(FreeKeysList.this.mc.f_91080_).f_96543_ / 2 - this.text.length() / 2), (int)(y + height - 9 - 1), (int)0xFFFFFF);
        }
    }

    public class InputEntry
    extends KeyBindsList.Entry {
        private final InputConstants.Key input;

        public InputEntry(InputConstants.Key input) {
            this.input = input;
        }

        public InputConstants.Key getInput() {
            return this.input;
        }

        public void m_6311_(PoseStack stack, int slotIndex, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            String str = this.input.toString() + " - " + this.input.m_84873_();
            int length = FreeKeysList.this.mc.f_91062_.m_92895_(this.input.m_84875_().getString());
            FreeKeysList.this.mc.f_91062_.m_92883_(stack, str, (float)x, (float)(y + height / 2 - 4), 0xFFFFFF);
            FreeKeysList.this.controlsScreen.m_96602_(stack, this.input.m_84875_(), x + width - length, y + height);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }
    }
}

