/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.worldgen.AllWorldFeatures;
import com.simibubi.create.foundation.worldgen.ConfigDrivenFeatureEntry;
import com.simibubi.create.foundation.worldgen.ConfigDrivenOreConfiguration;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ConfigDrivenDecorator
extends PlacementModifier {
    public static PlacementModifierType<ConfigDrivenDecorator> TYPE;
    public static final Codec<ConfigDrivenDecorator> CODEC;
    private ResourceLocation key;

    public ConfigDrivenDecorator(String key) {
        this.key = Create.asResource(key);
    }

    public PlacementModifierType<?> m_183327_() {
        return TYPE;
    }

    public Stream<BlockPos> m_183381_(PlacementContext context, Random random, BlockPos pos) {
        ConfigDrivenOreConfiguration config = (ConfigDrivenOreConfiguration)this.entry().getFeature().getFirst().f_65378_;
        float frequency = config.getFrequency();
        int floored = Mth.m_14143_((float)frequency);
        int count = floored + (random.nextFloat() < frequency - (float)floored ? 1 : 0);
        if (count == 0) {
            return Stream.empty();
        }
        int maxY = config.getMaxY();
        int minY = config.getMinY();
        return IntStream.range(0, count).mapToObj($ -> pos).map(p -> {
            int i = p.m_123341_();
            int j = p.m_123343_();
            int k = random.nextInt(maxY - minY) + minY;
            return new BlockPos(i, k, j);
        });
    }

    protected ConfigDrivenFeatureEntry entry() {
        return AllWorldFeatures.ENTRIES.get(this.key);
    }

    static {
        CODEC = RecordCodecBuilder.create(p_67849_ -> p_67849_.group((App)Codec.STRING.fieldOf("key").forGetter(t -> t.key.m_135815_())).apply((Applicative)p_67849_, ConfigDrivenDecorator::new));
    }
}

