/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.recipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;

public class RecipeFinder {
    private static Cache<Object, List<Recipe<?>>> cachedSearches = CacheBuilder.newBuilder().build();
    public static final ResourceManagerReloadListener LISTENER = resourceManager -> cachedSearches.invalidateAll();

    public static List<Recipe<?>> get(@Nullable Object cacheKey, Level world, Predicate<Recipe<?>> conditions) {
        if (cacheKey == null) {
            return RecipeFinder.startSearch(world, conditions);
        }
        try {
            return (List)cachedSearches.get(cacheKey, () -> RecipeFinder.startSearch(world, conditions));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private static List<Recipe<?>> startSearch(Level world, Predicate<? super Recipe<?>> conditions) {
        List<Recipe<?>> list = world.m_7465_().m_44051_().stream().filter(conditions).collect(Collectors.toList());
        return list;
    }
}

