/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.gui.widget.ElementWidget;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class PonderButton
extends BoxWidget {
    protected ItemStack item;
    protected PonderTag tag;
    protected KeyMapping shortcut;
    protected LerpedFloat flash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);

    public PonderButton(int x, int y) {
        this(x, y, 20, 20);
    }

    public PonderButton(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.z = 400.0f;
        this.paddingX = 2.0f;
        this.paddingY = 2.0f;
    }

    public <T extends PonderButton> T withShortcut(KeyMapping key) {
        this.shortcut = key;
        return (T)this;
    }

    public <T extends PonderButton> T showingTag(PonderTag tag) {
        this.tag = tag;
        return (T)((PonderButton)this.showing(this.tag));
    }

    public <T extends PonderButton> T showing(ItemStack item) {
        this.item = item;
        return (T)((PonderButton)super.showingElement((RenderElement)GuiGameElement.of(item).scale(1.5).at(-4.0f, -4.0f)));
    }

    @Override
    public <T extends ElementWidget> T showingElement(RenderElement element) {
        return super.showingElement(element);
    }

    public void flash() {
        this.flash.updateChaseTarget(1.0f);
    }

    public void dim() {
        this.flash.updateChaseTarget(0.0f);
    }

    @Override
    public void tick() {
        super.tick();
        this.flash.tickChaser();
    }

    @Override
    protected void beforeRender(@Nonnull PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(ms, mouseX, mouseY, partialTicks);
        float flashValue = this.flash.getValue(partialTicks);
        if (flashValue > 0.1f) {
            float sin = 0.5f + 0.5f * Mth.m_14031_((float)(((float)AnimationTickHolder.getTicks(true) + partialTicks) / 5.0f));
            Color nc1 = new Color(255, 255, 255, Mth.m_14045_((int)(this.gradientColor1.getAlpha() + 150), (int)0, (int)255));
            Color nc2 = new Color(155, 155, 155, Mth.m_14045_((int)(this.gradientColor2.getAlpha() + 150), (int)0, (int)255));
            this.gradientColor1 = this.gradientColor1.mixWith(nc1, sin *= flashValue);
            this.gradientColor2 = this.gradientColor2.mixWith(nc2, sin);
        }
    }

    @Override
    public void m_6303_(@Nonnull PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        super.m_6303_(ms, mouseX, mouseY, partialTicks);
        float fadeValue = this.fade.getValue();
        if (fadeValue < 0.1f) {
            return;
        }
        if (this.shortcut != null) {
            ms.m_85837_(0.0, 0.0, (double)(this.z + 50.0f));
            PonderButton.m_93215_((PoseStack)ms, (Font)Minecraft.m_91087_().f_91062_, (Component)this.shortcut.m_90863_(), (int)(this.f_93620_ + this.f_93618_ / 2 + 8), (int)(this.f_93621_ + this.f_93619_ - 6), (int)Theme.c(Theme.Key.TEXT_DARKER).scaleAlpha(fadeValue).getRGB());
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    @Override
    public Theme.Key getDisabledTheme() {
        return Theme.Key.PONDER_BUTTON_DISABLE;
    }

    @Override
    public Theme.Key getIdleTheme() {
        return Theme.Key.PONDER_BUTTON_IDLE;
    }

    @Override
    public Theme.Key getHoverTheme() {
        return Theme.Key.PONDER_BUTTON_HOVER;
    }

    @Override
    public Theme.Key getClickTheme() {
        return Theme.Key.PONDER_BUTTON_CLICK;
    }
}

