/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.networking;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public abstract class TileEntityDataPacket<TE extends SyncedTileEntity>
extends SimplePacketBase {
    protected BlockPos tilePos;

    public TileEntityDataPacket(FriendlyByteBuf buffer) {
        this.tilePos = buffer.m_130135_();
    }

    public TileEntityDataPacket(BlockPos pos) {
        this.tilePos = pos;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.tilePos);
        this.writeData(buffer);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return;
            }
            BlockEntity tile = world.m_7702_(this.tilePos);
            if (tile instanceof SyncedTileEntity) {
                this.handlePacket((SyncedTileEntity)tile);
            }
        });
        ctx.setPacketHandled(true);
    }

    protected abstract void writeData(FriendlyByteBuf var1);

    protected abstract void handlePacket(TE var1);
}

