/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ISpecialEntityItemRequirement;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class ItemRequirement {
    List<StackRequirement> requiredItems;
    public static final ItemRequirement INVALID = new ItemRequirement();
    public static final ItemRequirement NONE = new ItemRequirement();

    private ItemRequirement() {
    }

    public ItemRequirement(List<StackRequirement> requiredItems) {
        this.requiredItems = requiredItems;
    }

    public ItemRequirement(ItemUseType usage, ItemStack items) {
        this(Arrays.asList(new StackRequirement(usage, items)));
    }

    public ItemRequirement(ItemUseType usage, Item item) {
        this(usage, new ItemStack((ItemLike)item));
    }

    public ItemRequirement(ItemUseType usage, List<ItemStack> requiredItems) {
        this(requiredItems.stream().map(req -> new StackRequirement(usage, (ItemStack)req)).collect(Collectors.toList()));
    }

    public static ItemRequirement of(BlockState state, BlockEntity te) {
        Block block = state.m_60734_();
        ItemRequirement baseRequirement = block instanceof ISpecialBlockItemRequirement ? ((ISpecialBlockItemRequirement)block).getRequiredItems(state, te) : ItemRequirement.ofBlockState(state, block);
        if (te instanceof SmartTileEntity) {
            baseRequirement = baseRequirement.with(((SmartTileEntity)te).getRequiredItems());
        }
        return baseRequirement;
    }

    private static ItemRequirement ofBlockState(BlockState state, Block block) {
        if (block == Blocks.f_50016_) {
            return NONE;
        }
        Item item = BlockItem.f_41373_.getOrDefault(state.m_60734_(), Items.f_41852_);
        if (state.m_61138_((Property)BlockStateProperties.f_61397_) && state.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.DOUBLE) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((ItemLike)item, 2)));
        }
        if (block instanceof TurtleEggBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((ItemLike)item, ((Integer)state.m_61143_((Property)TurtleEggBlock.f_57754_)).intValue())));
        }
        if (block instanceof SeaPickleBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((ItemLike)item, ((Integer)state.m_61143_((Property)SeaPickleBlock.f_56074_)).intValue())));
        }
        if (block instanceof SnowLayerBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((ItemLike)item, ((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_)).intValue())));
        }
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((ItemLike)Items.f_42329_)));
        }
        return item == Items.f_41852_ ? INVALID : new ItemRequirement(ItemUseType.CONSUME, item);
    }

    public static ItemRequirement of(Entity entity) {
        EntityType type = entity.m_6095_();
        if (entity instanceof ISpecialEntityItemRequirement) {
            return ((ISpecialEntityItemRequirement)entity).getRequiredItems();
        }
        if (type == EntityType.f_20462_) {
            ItemFrame ife = (ItemFrame)entity;
            ItemStack frame = new ItemStack((ItemLike)Items.f_42617_);
            ItemStack displayedItem = ife.m_31822_();
            if (displayedItem.m_41619_()) {
                return new ItemRequirement(ItemUseType.CONSUME, Items.f_42617_);
            }
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(frame, displayedItem));
        }
        if (type == EntityType.f_20506_) {
            return new ItemRequirement(ItemUseType.CONSUME, Items.f_42487_);
        }
        if (type == EntityType.f_20529_) {
            ArrayList<ItemStack> requirements = new ArrayList<ItemStack>();
            ArmorStand armorStandEntity = (ArmorStand)entity;
            armorStandEntity.m_20158_().forEach(requirements::add);
            requirements.add(new ItemStack((ItemLike)Items.f_42650_));
            return new ItemRequirement(ItemUseType.CONSUME, requirements);
        }
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart minecartEntity = (AbstractMinecart)entity;
            return new ItemRequirement(ItemUseType.CONSUME, minecartEntity.getCartItem().m_41720_());
        }
        if (entity instanceof Boat) {
            Boat boatEntity = (Boat)entity;
            return new ItemRequirement(ItemUseType.CONSUME, boatEntity.m_38369_());
        }
        if (type == EntityType.f_20564_) {
            return new ItemRequirement(ItemUseType.CONSUME, Items.f_42729_);
        }
        return INVALID;
    }

    public boolean isEmpty() {
        return NONE == this;
    }

    public boolean isInvalid() {
        return INVALID == this;
    }

    public List<StackRequirement> getRequiredItems() {
        return this.requiredItems;
    }

    public static boolean validate(ItemStack required, ItemStack present) {
        return required.m_41619_() || required.m_41720_() == present.m_41720_();
    }

    public ItemRequirement with(ItemRequirement other) {
        if (this.isInvalid() || other.isInvalid()) {
            return INVALID;
        }
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return new ItemRequirement(Stream.concat(this.requiredItems.stream(), other.requiredItems.stream()).collect(Collectors.toList()));
    }

    public static class StackRequirement {
        public final ItemStack item;
        public final ItemUseType usage;

        public StackRequirement(ItemUseType usage, ItemStack item) {
            this.item = item;
            this.usage = usage;
        }
    }

    public static enum ItemUseType {
        CONSUME,
        DAMAGE;

    }
}

