/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmBlock;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ArmRenderer
extends KineticTileEntityRenderer {
    public ArmRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float pt, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        int color;
        float headAngle;
        float upperArmAngle;
        float lowerArmAngle;
        float baseAngle;
        boolean rave;
        super.renderSafe(te, pt, ms, buffer, light, overlay);
        ArmTileEntity arm = (ArmTileEntity)te;
        ItemStack item = arm.heldItem;
        boolean hasItem = !item.m_41619_();
        boolean usingFlywheel = Backend.canUseInstancing((Level)te.m_58904_());
        if (usingFlywheel && !hasItem) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        boolean isBlockItem = hasItem && item.m_41720_() instanceof BlockItem && itemRenderer.m_174264_(item, te.m_58904_(), null, 0).m_7539_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        BlockState blockState = te.m_58900_();
        PoseStack msLocal = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)msLocal);
        boolean bl = rave = arm.phase == ArmTileEntity.Phase.DANCING && te.getSpeed() != 0.0f;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_()) + (float)(te.hashCode() % 64);
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = Mth.m_14179_((float)((Mth.m_14031_((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
            upperArmAngle = Mth.m_14179_((float)((Mth.m_14031_((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
            headAngle = -lowerArmAngle;
            color = Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB();
        } else {
            baseAngle = arm.baseAngle.get(pt);
            lowerArmAngle = arm.lowerArmAngle.get(pt) - 135.0f;
            upperArmAngle = arm.upperArmAngle.get(pt) - 90.0f;
            headAngle = arm.headAngle.get(pt);
            color = 0xFFFFFF;
        }
        msr.centre();
        if (((Boolean)blockState.m_61143_((Property)ArmBlock.CEILING)).booleanValue()) {
            msr.rotateX(180.0);
        }
        if (usingFlywheel) {
            this.doItemTransforms(msr, baseAngle, lowerArmAngle, upperArmAngle, headAngle);
        } else {
            this.renderArm(builder, ms, msLocal, msr, blockState, color, baseAngle, lowerArmAngle, upperArmAngle, headAngle, hasItem, isBlockItem, light);
        }
        if (hasItem) {
            ms.m_85836_();
            float itemScale = isBlockItem ? 0.5f : 0.625f;
            msr.rotateX(90.0);
            msLocal.m_85837_(0.0, -0.25, 0.0);
            msLocal.m_85841_(itemScale, itemScale, itemScale);
            ms.m_85850_().m_85861_().m_27644_(msLocal.m_85850_().m_85861_());
            itemRenderer.m_174269_(item, ItemTransforms.TransformType.FIXED, light, overlay, ms, buffer, 0);
            ms.m_85849_();
        }
    }

    private void renderArm(VertexConsumer builder, PoseStack ms, PoseStack msLocal, TransformStack msr, BlockState blockState, int color, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, boolean hasItem, boolean isBlockItem, int light) {
        SuperByteBuffer base = CachedBufferer.partial(AllBlockPartials.ARM_BASE, blockState).light(light);
        SuperByteBuffer lowerBody = CachedBufferer.partial(AllBlockPartials.ARM_LOWER_BODY, blockState).light(light);
        SuperByteBuffer upperBody = CachedBufferer.partial(AllBlockPartials.ARM_UPPER_BODY, blockState).light(light);
        SuperByteBuffer head = CachedBufferer.partial(AllBlockPartials.ARM_HEAD, blockState).light(light);
        SuperByteBuffer claw = CachedBufferer.partial(AllBlockPartials.ARM_CLAW_BASE, blockState).light(light);
        SuperByteBuffer clawGrip = CachedBufferer.partial(AllBlockPartials.ARM_CLAW_GRIP, blockState);
        ArmRenderer.transformBase(msr, baseAngle);
        base.transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        lowerBody.color(color).transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        upperBody.color(color).transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformHead(msr, headAngle);
        head.transform(msLocal).renderInto(ms, builder);
        ArmRenderer.transformClaw(msr);
        claw.transform(msLocal).renderInto(ms, builder);
        for (int flip : Iterate.positiveAndNegative) {
            msLocal.m_85836_();
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            clawGrip.light(light).transform(msLocal).renderInto(ms, builder);
            msLocal.m_85849_();
        }
    }

    private void doItemTransforms(TransformStack msr, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle) {
        ArmRenderer.transformBase(msr, baseAngle);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        ArmRenderer.transformHead(msr, headAngle);
        ArmRenderer.transformClaw(msr);
    }

    public static void transformClawHalf(TransformStack msr, boolean hasItem, boolean isBlockItem, int flip) {
        msr.translate(0.0, (double)(flip * 3) / 16.0, -0.0625);
        msr.rotateX((double)(flip * (hasItem ? (isBlockItem ? 0 : -35) : 0)));
    }

    public static void transformClaw(TransformStack msr) {
        msr.translate(0.0, 0.0, -0.25);
    }

    public static void transformHead(TransformStack msr, float headAngle) {
        msr.translate(0.0, 0.6875, -0.6875);
        msr.rotateX((double)headAngle);
    }

    public static void transformUpperArm(TransformStack msr, float upperArmAngle) {
        msr.translate(0.0, 0.75, 0.75);
        msr.rotateX((double)upperArmAngle);
    }

    public static void transformLowerArm(TransformStack msr, float lowerArmAngle) {
        msr.translate(0.0, 0.0625, -0.125);
        msr.rotateX((double)lowerArmAngle);
        msr.translate(0.0, -0.0625, 0.0);
    }

    public static void transformBase(TransformStack msr, float baseAngle) {
        msr.translate(0.0, 0.25, 0.0);
        msr.rotateY((double)baseAngle);
    }

    public boolean shouldRenderOffScreen(KineticTileEntity te) {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te, BlockState state) {
        return CachedBufferer.partial(AllBlockPartials.ARM_COG, state);
    }
}

