/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.logistics.block.chute.ChuteBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChuteShapes {
    static Map<BlockState, VoxelShape> cache = new HashMap<BlockState, VoxelShape>();
    static Map<BlockState, VoxelShape> collisionCache = new HashMap<BlockState, VoxelShape>();
    public static final VoxelShape INTERSECTION_MASK = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape COLLISION_MASK = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);
    public static final VoxelShape PANEL = Block.m_49796_((double)1.0, (double)-15.0, (double)0.0, (double)15.0, (double)4.0, (double)1.0);

    public static VoxelShape createShape(BlockState state) {
        boolean intersection;
        if (AllBlocks.SMART_CHUTE.has(state)) {
            return AllShapes.SMART_CHUTE;
        }
        Direction direction = (Direction)state.m_61143_((Property)ChuteBlock.FACING);
        ChuteBlock.Shape shape = (ChuteBlock.Shape)((Object)state.m_61143_(ChuteBlock.SHAPE));
        boolean bl = intersection = shape == ChuteBlock.Shape.INTERSECTION;
        if (direction == Direction.DOWN) {
            return intersection ? Shapes.m_83144_() : AllShapes.CHUTE;
        }
        VoxelShape combineWith = intersection ? Shapes.m_83144_() : Shapes.m_83040_();
        VoxelShape result = Shapes.m_83110_((VoxelShape)combineWith, (VoxelShape)AllShapes.CHUTE_SLOPE.get(direction));
        if (intersection) {
            result = Shapes.m_83148_((VoxelShape)INTERSECTION_MASK, (VoxelShape)result, (BooleanOp)BooleanOp.f_82689_);
        }
        return result;
    }

    public static VoxelShape getShape(BlockState state) {
        if (cache.containsKey(state)) {
            return cache.get(state);
        }
        VoxelShape createdShape = ChuteShapes.createShape(state);
        cache.put(state, createdShape);
        return createdShape;
    }

    public static VoxelShape getCollisionShape(BlockState state) {
        if (collisionCache.containsKey(state)) {
            return collisionCache.get(state);
        }
        VoxelShape createdShape = Shapes.m_83148_((VoxelShape)COLLISION_MASK, (VoxelShape)ChuteShapes.getShape(state), (BooleanOp)BooleanOp.f_82689_);
        collisionCache.put(state, createdShape);
        return createdShape;
    }

    public static VoxelShape createSlope() {
        VoxelShape shape = Shapes.m_83040_();
        for (int i = 0; i < 16; ++i) {
            float offset = (float)i / 16.0f;
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)PANEL.m_83216_(0.0, (double)offset, (double)offset), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }
}

