/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry.mirror;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlaneMirror
extends SymmetryMirror {
    public PlaneMirror(Vec3 pos) {
        super(pos);
        this.orientation = Align.XY;
    }

    @Override
    protected void setOrientation() {
        if (this.orientationIndex < 0) {
            this.orientationIndex += Align.values().length;
        }
        if (this.orientationIndex >= Align.values().length) {
            this.orientationIndex -= Align.values().length;
        }
        this.orientation = Align.values()[this.orientationIndex];
    }

    @Override
    public void setOrientation(int index) {
        this.orientation = Align.values()[index];
        this.orientationIndex = index;
    }

    @Override
    public Map<BlockPos, BlockState> process(BlockPos position, BlockState block) {
        HashMap<BlockPos, BlockState> result = new HashMap<BlockPos, BlockState>();
        switch ((Align)this.orientation) {
            case XY: {
                result.put(this.flipZ(position), this.flipZ(block));
                break;
            }
            case YZ: {
                result.put(this.flipX(position), this.flipX(block));
                break;
            }
        }
        return result;
    }

    @Override
    public String typeName() {
        return "plane";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getModel() {
        return AllBlockPartials.SYMMETRY_PLANE;
    }

    @Override
    public void applyModelTransform(PoseStack ms) {
        super.applyModelTransform(ms);
        ((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).centre()).rotateY((Align)this.orientation == Align.XY ? 0.0 : 90.0)).unCentre();
    }

    @Override
    public List<Component> getAlignToolTips() {
        return ImmutableList.of((Object)Lang.translate("orientation.alongZ", new Object[0]), (Object)Lang.translate("orientation.alongX", new Object[0]));
    }

    public static enum Align implements StringRepresentable
    {
        XY("xy"),
        YZ("yz");

        private final String name;

        private Align(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

