/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry;

import com.simibubi.create.content.curiosities.symmetry.SymmetryHandler;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SymmetryEffectPacket
extends SimplePacketBase {
    private BlockPos mirror;
    private List<BlockPos> positions;

    public SymmetryEffectPacket(BlockPos mirror, List<BlockPos> positions) {
        this.mirror = mirror;
        this.positions = positions;
    }

    public SymmetryEffectPacket(FriendlyByteBuf buffer) {
        this.mirror = buffer.m_130135_();
        int amt = buffer.readInt();
        this.positions = new ArrayList<BlockPos>(amt);
        for (int i = 0; i < amt; ++i) {
            this.positions.add(buffer.m_130135_());
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.mirror);
        buffer.writeInt(this.positions.size());
        for (BlockPos blockPos : this.positions) {
            buffer.m_130064_(blockPos);
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(Vec3.m_82528_((Vec3i)this.mirror)) > 100.0) {
                return;
            }
            for (BlockPos to : this.positions) {
                SymmetryHandler.drawEffect(this.mirror, to);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

