/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractShaftBlock;
import com.simibubi.create.content.contraptions.relays.encased.EncasedShaftBlock;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.util.PoleHelper;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShaftBlock
extends AbstractShaftBlock {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public ShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean isShaft(BlockState state) {
        return AllBlocks.SHAFT.has(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.SIX_VOXEL_POLE.get((Direction.Axis)state.m_61143_((Property)AXIS));
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.35f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.125f;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        for (EncasedShaftBlock encasedShaft : new EncasedShaftBlock[]{(EncasedShaftBlock)AllBlocks.ANDESITE_ENCASED_SHAFT.get(), (EncasedShaftBlock)AllBlocks.BRASS_ENCASED_SHAFT.get()}) {
            if (!encasedShaft.getCasing().isIn(heldItem)) continue;
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            AllTriggers.triggerFor(AllTriggers.CASING_SHAFT, player);
            KineticTileEntity.switchToBlockState(world, pos, (BlockState)encasedShaft.m_49966_().m_61124_((Property)AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)AXIS))));
            return InteractionResult.SUCCESS;
        }
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.m_60734_() instanceof AbstractShaftBlock, state -> (Direction.Axis)state.m_61143_(RotatedPillarKineticBlock.AXIS), RotatedPillarKineticBlock.AXIS);
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof AbstractShaftBlock;
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return AllBlocks.SHAFT::has;
        }
    }
}

