/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class BracketedKineticTileRenderer
extends KineticTileEntityRenderer {
    public BracketedKineticTileRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        if (!AllBlocks.LARGE_COGWHEEL.has(te.m_58900_())) {
            super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
            return;
        }
        Direction.Axis axis = BracketedKineticTileRenderer.getRotationAxisOf(te);
        BlockPos pos = te.m_58899_();
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BracketedKineticTileRenderer.renderRotatingBuffer(te, CachedBufferer.partialFacingVertical(AllBlockPartials.SHAFTLESS_LARGE_COGWHEEL, te.m_58900_(), facing), ms, buffer.m_6299_(RenderType.m_110451_()), light);
        float offset = BracketedKineticTileRenderer.getShaftAngleOffset(axis, pos);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        float angle = (time * te.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        SuperByteBuffer shaft = CachedBufferer.partialFacingVertical(AllBlockPartials.COGWHEEL_SHAFT, te.m_58900_(), facing);
        BracketedKineticTileRenderer.kineticRotationTransform(shaft, te, axis, angle, light);
        shaft.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    public static float getShaftAngleOffset(Direction.Axis axis, BlockPos pos) {
        float offset = 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.m_123341_()) + (axis == Direction.Axis.Y ? 0 : pos.m_123342_()) + (axis == Direction.Axis.Z ? 0 : pos.m_123343_())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }
}

