/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;

public class BlazeBurnerRenderer
extends SafeTileEntityRenderer<BlazeBurnerTileEntity> {
    public BlazeBurnerRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(BlazeBurnerTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlazeBurnerBlock.HeatLevel heatLevel = te.getHeatLevelFromBlock();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_()) + (float)(te.hashCode() % 13) * 16.0f;
        float offset = (Mth.m_14031_((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) + 0.5f) / 16.0f;
        PartialModel blazeModel = AllBlockPartials.BLAZES.get((Object)heatLevel);
        SuperByteBuffer blazeBuffer = CachedBufferer.partial(blazeModel, te.m_58900_());
        blazeBuffer.rotateCentered(Direction.UP, AngleHelper.rad(te.headAngle.getValue(partialTicks)));
        blazeBuffer.translate(0.0, offset, 0.0);
        blazeBuffer.light(0xF000F0).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }
}

