/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingRecipeBuilder<T extends ProcessingRecipe<?>> {
    protected ProcessingRecipeFactory<T> factory;
    protected ProcessingRecipeParams params;
    protected List<ICondition> recipeConditions;

    public ProcessingRecipeBuilder(ProcessingRecipeFactory<T> factory, ResourceLocation recipeId) {
        this.params = new ProcessingRecipeParams(recipeId);
        this.recipeConditions = new ArrayList<ICondition>();
        this.factory = factory;
    }

    public ProcessingRecipeBuilder<T> withItemIngredients(Ingredient ... ingredients) {
        return this.withItemIngredients((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }

    public ProcessingRecipeBuilder<T> withItemIngredients(NonNullList<Ingredient> ingredients) {
        this.params.ingredients = ingredients;
        return this;
    }

    public ProcessingRecipeBuilder<T> withSingleItemOutput(ItemStack output) {
        return this.withItemOutputs(new ProcessingOutput(output, 1.0f));
    }

    public ProcessingRecipeBuilder<T> withItemOutputs(ProcessingOutput ... outputs) {
        return this.withItemOutputs((NonNullList<ProcessingOutput>)NonNullList.m_122783_((Object)ProcessingOutput.EMPTY, (Object[])outputs));
    }

    public ProcessingRecipeBuilder<T> withItemOutputs(NonNullList<ProcessingOutput> outputs) {
        this.params.results = outputs;
        return this;
    }

    public ProcessingRecipeBuilder<T> withFluidIngredients(FluidIngredient ... ingredients) {
        return this.withFluidIngredients((NonNullList<FluidIngredient>)NonNullList.m_122783_((Object)FluidIngredient.EMPTY, (Object[])ingredients));
    }

    public ProcessingRecipeBuilder<T> withFluidIngredients(NonNullList<FluidIngredient> ingredients) {
        this.params.fluidIngredients = ingredients;
        return this;
    }

    public ProcessingRecipeBuilder<T> withFluidOutputs(FluidStack ... outputs) {
        return this.withFluidOutputs((NonNullList<FluidStack>)NonNullList.m_122783_((Object)FluidStack.EMPTY, (Object[])outputs));
    }

    public ProcessingRecipeBuilder<T> withFluidOutputs(NonNullList<FluidStack> outputs) {
        this.params.fluidResults = outputs;
        return this;
    }

    public ProcessingRecipeBuilder<T> duration(int ticks) {
        this.params.processingDuration = ticks;
        return this;
    }

    public ProcessingRecipeBuilder<T> averageProcessingDuration() {
        return this.duration(100);
    }

    public ProcessingRecipeBuilder<T> requiresHeat(HeatCondition condition) {
        this.params.requiredHeat = condition;
        return this;
    }

    public T build() {
        return this.factory.create(this.params);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new DataGenResult<T>(this.build(), this.recipeConditions));
    }

    public ProcessingRecipeBuilder<T> require(Tag.Named<Item> tag) {
        return this.require(Ingredient.m_43911_(tag));
    }

    public ProcessingRecipeBuilder<T> require(ItemLike item) {
        return this.require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ProcessingRecipeBuilder<T> require(Ingredient ingredient) {
        this.params.ingredients.add((Object)ingredient);
        return this;
    }

    public ProcessingRecipeBuilder<T> require(Fluid fluid, int amount) {
        return this.require(FluidIngredient.fromFluid(fluid, amount));
    }

    public ProcessingRecipeBuilder<T> require(Tag.Named<Fluid> fluidTag, int amount) {
        return this.require(FluidIngredient.fromTag(fluidTag, amount));
    }

    public ProcessingRecipeBuilder<T> require(FluidIngredient ingredient) {
        this.params.fluidIngredients.add((Object)ingredient);
        return this;
    }

    public ProcessingRecipeBuilder<T> output(ItemLike item) {
        return this.output(item, 1);
    }

    public ProcessingRecipeBuilder<T> output(float chance, ItemLike item) {
        return this.output(chance, item, 1);
    }

    public ProcessingRecipeBuilder<T> output(ItemLike item, int amount) {
        return this.output(1.0f, item, amount);
    }

    public ProcessingRecipeBuilder<T> output(float chance, ItemLike item, int amount) {
        return this.output(chance, new ItemStack(item, amount));
    }

    public ProcessingRecipeBuilder<T> output(ItemStack output) {
        return this.output(1.0f, output);
    }

    public ProcessingRecipeBuilder<T> output(float chance, ItemStack output) {
        this.params.results.add((Object)new ProcessingOutput(output, chance));
        return this;
    }

    public ProcessingRecipeBuilder<T> output(float chance, ResourceLocation registryName, int amount) {
        this.params.results.add((Object)new ProcessingOutput(Pair.of(registryName, amount), chance));
        return this;
    }

    public ProcessingRecipeBuilder<T> output(Fluid fluid, int amount) {
        fluid = FluidHelper.convertToStill(fluid);
        return this.output(new FluidStack(fluid, amount));
    }

    public ProcessingRecipeBuilder<T> output(FluidStack fluidStack) {
        this.params.fluidResults.add((Object)fluidStack);
        return this;
    }

    public ProcessingRecipeBuilder<T> toolNotConsumed() {
        this.params.keepHeldItem = true;
        return this;
    }

    public ProcessingRecipeBuilder<T> whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public ProcessingRecipeBuilder<T> whenModMissing(String modid) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    public ProcessingRecipeBuilder<T> withCondition(ICondition condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public static class ProcessingRecipeParams {
        protected ResourceLocation id;
        protected NonNullList<Ingredient> ingredients;
        protected NonNullList<ProcessingOutput> results;
        protected NonNullList<FluidIngredient> fluidIngredients;
        protected NonNullList<FluidStack> fluidResults;
        protected int processingDuration;
        protected HeatCondition requiredHeat;
        public boolean keepHeldItem;

        protected ProcessingRecipeParams(ResourceLocation id) {
            this.id = id;
            this.ingredients = NonNullList.m_122779_();
            this.results = NonNullList.m_122779_();
            this.fluidIngredients = NonNullList.m_122779_();
            this.fluidResults = NonNullList.m_122779_();
            this.processingDuration = 0;
            this.requiredHeat = HeatCondition.NONE;
            this.keepHeldItem = false;
        }
    }

    @FunctionalInterface
    public static interface ProcessingRecipeFactory<T extends ProcessingRecipe<?>> {
        public T create(ProcessingRecipeParams var1);
    }

    public static class DataGenResult<S extends ProcessingRecipe<?>>
    implements FinishedRecipe {
        private List<ICondition> recipeConditions;
        private ProcessingRecipeSerializer<S> serializer;
        private ResourceLocation id;
        private S recipe;

        public DataGenResult(S recipe, List<ICondition> recipeConditions) {
            this.recipe = recipe;
            this.recipeConditions = recipeConditions;
            IRecipeTypeInfo recipeType = ((ProcessingRecipe)this.recipe).getTypeInfo();
            ResourceLocation typeId = recipeType.getId();
            if (!(recipeType.getSerializer() instanceof ProcessingRecipeSerializer)) {
                throw new IllegalStateException("Cannot datagen ProcessingRecipe of type: " + typeId);
            }
            this.id = new ResourceLocation(((ProcessingRecipe)recipe).m_6423_().m_135827_(), typeId.m_135815_() + "/" + ((ProcessingRecipe)recipe).m_6423_().m_135815_());
            this.serializer = (ProcessingRecipeSerializer)((ProcessingRecipe)recipe).m_7707_();
        }

        public void m_7917_(JsonObject json) {
            this.serializer.write(json, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conds);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

