/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class ProcessingInventory
extends ItemStackHandler {
    public float remainingTime;
    public float recipeDuration;
    public boolean appliedRecipe;
    public Consumer<ItemStack> callback;
    private boolean limit;

    public ProcessingInventory(Consumer<ItemStack> callback) {
        super(16);
        this.callback = callback;
    }

    public ProcessingInventory withSlotLimit(boolean limit) {
        this.limit = limit;
        return this;
    }

    public int getSlotLimit(int slot) {
        return !this.limit ? super.getSlotLimit(slot) : 1;
    }

    public void clear() {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.remainingTime = 0.0f;
        this.recipeDuration = 0.0f;
        this.appliedRecipe = false;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack insertItem = super.insertItem(slot, stack, simulate);
        if (slot == 0 && !insertItem.equals(stack, true)) {
            this.callback.accept(this.getStackInSlot(slot));
        }
        return insertItem;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128350_("ProcessingTime", this.remainingTime);
        nbt.m_128350_("RecipeTime", this.recipeDuration);
        nbt.m_128379_("AppliedRecipe", this.appliedRecipe);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.remainingTime = nbt.m_128457_("ProcessingTime");
        this.recipeDuration = nbt.m_128457_("RecipeTime");
        this.appliedRecipe = nbt.m_128471_("AppliedRecipe");
        super.deserializeNBT(nbt);
        if (this.isEmpty()) {
            this.appliedRecipe = false;
        }
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && this.isEmpty();
    }
}

