/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SuperGlueRenderer
extends EntityRenderer<SuperGlueEntity> {
    private ResourceLocation regular = Create.asResource("textures/entity/super_glue/slime.png");
    private float[] insideQuad;
    private float[] outsideQuad;

    public SuperGlueRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.initQuads();
    }

    public ResourceLocation getTextureLocation(SuperGlueEntity entity) {
        return this.regular;
    }

    public boolean shouldRender(SuperGlueEntity entity, Frustum frustum, double x, double y, double z) {
        if (super.m_5523_((Entity)entity, frustum, x, y, z)) {
            boolean holdingGlue;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            boolean visible = entity.isVisible();
            boolean bl = holdingGlue = AllItems.SUPER_GLUE.isIn(player.m_21205_()) || AllItems.SUPER_GLUE.isIn(player.m_21206_());
            if (visible || holdingGlue) {
                return true;
            }
        }
        return false;
    }

    public void render(SuperGlueEntity entity, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        super.m_7392_((Entity)entity, yaw, partialTicks, ms, buffer, light);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity)));
        light = this.getBrightnessForRender(entity);
        Direction face = entity.getFacingDirection();
        ms.m_85836_();
        ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)AngleHelper.horizontalAngle(face))).rotateX((double)AngleHelper.verticalAngle(face));
        PoseStack.Pose peek = ms.m_85850_();
        this.renderQuad(builder, peek, this.insideQuad, light, -1.0f);
        this.renderQuad(builder, peek, this.outsideQuad, light, 1.0f);
        ms.m_85849_();
    }

    private void initQuads() {
        Vec3 diff = Vec3.m_82528_((Vec3i)Direction.SOUTH.m_122436_());
        Vec3 extension = diff.m_82541_().m_82490_(0.0234375);
        Vec3 plane = VecHelper.axisAlingedPlaneOf(diff);
        Direction.Axis axis = Direction.m_122366_((double)diff.f_82479_, (double)diff.f_82480_, (double)diff.f_82481_).m_122434_();
        Vec3 start = Vec3.f_82478_.m_82546_(extension);
        Vec3 end = Vec3.f_82478_.m_82549_(extension);
        plane = plane.m_82490_(0.5);
        Vec3 a1 = plane.m_82549_(start);
        Vec3 b1 = plane.m_82549_(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3 a2 = plane.m_82549_(start);
        Vec3 b2 = plane.m_82549_(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3 a3 = plane.m_82549_(start);
        Vec3 b3 = plane.m_82549_(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3 a4 = plane.m_82549_(start);
        Vec3 b4 = plane.m_82549_(end);
        this.insideQuad = new float[]{(float)a1.f_82479_, (float)a1.f_82480_, (float)a1.f_82481_, 1.0f, 0.0f, (float)a2.f_82479_, (float)a2.f_82480_, (float)a2.f_82481_, 1.0f, 1.0f, (float)a3.f_82479_, (float)a3.f_82480_, (float)a3.f_82481_, 0.0f, 1.0f, (float)a4.f_82479_, (float)a4.f_82480_, (float)a4.f_82481_, 0.0f, 0.0f};
        this.outsideQuad = new float[]{(float)b4.f_82479_, (float)b4.f_82480_, (float)b4.f_82481_, 0.0f, 0.0f, (float)b3.f_82479_, (float)b3.f_82480_, (float)b3.f_82481_, 0.0f, 1.0f, (float)b2.f_82479_, (float)b2.f_82480_, (float)b2.f_82481_, 1.0f, 1.0f, (float)b1.f_82479_, (float)b1.f_82480_, (float)b1.f_82481_, 1.0f, 0.0f};
    }

    private int getBrightnessForRender(SuperGlueEntity entity) {
        BlockPos blockpos = entity.getHangingPosition();
        BlockPos blockpos2 = blockpos.m_142300_(entity.getFacingDirection().m_122424_());
        Level world = entity.m_20193_();
        int light = world.m_46749_(blockpos) ? LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)blockpos) : 15;
        int light2 = world.m_46749_(blockpos2) ? LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)blockpos2) : 15;
        return Math.max(light, light2);
    }

    private void renderQuad(VertexConsumer builder, PoseStack.Pose matrix, float[] data, int light, float normalZ) {
        for (int i = 0; i < 4; ++i) {
            builder.m_85982_(matrix.m_85861_(), data[5 * i], data[5 * i + 1], data[5 * i + 2]).m_6122_(255, 255, 255, 255).m_7421_(data[5 * i + 3], data[5 * i + 4]).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix.m_85864_(), 0.0f, 0.0f, normalZ).m_5752_();
        }
    }
}

