/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GantryCarriageRenderer
extends KineticTileEntityRenderer {
    public GantryCarriageRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        BlockState state = te.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)GantryCarriageBlock.FACING);
        Boolean alongFirst = (Boolean)state.m_61143_((Property)GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        Direction.Axis rotationAxis = GantryCarriageRenderer.getRotationAxisOf(te);
        BlockPos visualPos = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? te.m_58899_() : te.m_58899_().m_142300_(facing.m_122424_());
        float angleForTe = GantryCarriageRenderer.getAngleForTe(te, visualPos, rotationAxis);
        Direction.Axis gantryAxis = Direction.Axis.X;
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == rotationAxis || axis == facing.m_122434_()) continue;
            gantryAxis = axis;
        }
        if (gantryAxis == Direction.Axis.X && facing == Direction.UP) {
            angleForTe *= -1.0f;
        }
        if (gantryAxis == Direction.Axis.Y && (facing == Direction.NORTH || facing == Direction.EAST)) {
            angleForTe *= -1.0f;
        }
        SuperByteBuffer cogs = CachedBufferer.partial(AllBlockPartials.GANTRY_COGS, state);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)cogs.centre()).rotateY(AngleHelper.horizontalAngle(facing))).rotateX(facing == Direction.UP ? 0.0 : (facing == Direction.DOWN ? 180.0 : 90.0))).rotateY(alongFirst ^ facing.m_122434_() == Direction.Axis.X ? 0.0 : 90.0)).translate(0.0, -0.5625, 0.0).rotateX(-angleForTe)).translate(0.0, 0.5625, 0.0).unCentre();
        cogs.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    public static float getAngleForTe(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        float offset = GantryCarriageRenderer.getRotationOffsetForPosition(te, pos, axis);
        return (time * te.getSpeed() * 3.0f / 20.0f + offset) % 360.0f;
    }

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return GantryCarriageRenderer.shaft(GantryCarriageRenderer.getRotationAxisOf(te));
    }
}

