/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.sync.ContraptionInteractionPacket;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.RaycastHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableObject;

@Mod.EventBusSubscriber
public class ContraptionHandlerClient {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void preventRemotePlayersWalkingAnimations(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!(event.player instanceof RemotePlayer)) {
            return;
        }
        RemotePlayer remotePlayer = (RemotePlayer)event.player;
        CompoundTag data = remotePlayer.getPersistentData();
        if (!data.m_128441_("LastOverrideLimbSwingUpdate")) {
            return;
        }
        int lastOverride = data.m_128451_("LastOverrideLimbSwingUpdate");
        data.m_128405_("LastOverrideLimbSwingUpdate", lastOverride + 1);
        if (lastOverride > 5) {
            data.m_128473_("LastOverrideLimbSwingUpdate");
            data.m_128473_("OverrideLimbSwing");
            return;
        }
        float limbSwing = data.m_128457_("OverrideLimbSwing");
        remotePlayer.f_19854_ = remotePlayer.m_20185_() - (double)(limbSwing / 4.0f);
        remotePlayer.f_19856_ = remotePlayer.m_20189_();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void rightClickingOnContraptionsGetsHandledLocally(InputEvent.ClickInputEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_20159_()) {
            return;
        }
        if (mc.f_91073_ == null) {
            return;
        }
        if (!event.isUseItem()) {
            return;
        }
        Vec3 origin = RaycastHelper.getTraceOrigin((Player)player);
        double reach = mc.f_91072_.m_105286_();
        if (mc.f_91077_ != null && mc.f_91077_.m_82450_() != null) {
            reach = Math.min(mc.f_91077_.m_82450_().m_82554_(origin), reach);
        }
        Vec3 target = RaycastHelper.getTraceTarget((Player)player, reach, origin);
        for (AbstractContraptionEntity contraptionEntity : mc.f_91073_.m_45976_(AbstractContraptionEntity.class, new AABB(origin, target))) {
            MutableObject mutableResult;
            Contraption contraption;
            Vec3 localTarget;
            Vec3 localOrigin = contraptionEntity.toLocalVector(origin, 1.0f);
            RaycastHelper.PredicateTraceResult predicateResult = RaycastHelper.rayTraceUntil(localOrigin, localTarget = contraptionEntity.toLocalVector(target, 1.0f), arg_0 -> ContraptionHandlerClient.lambda$rightClickingOnContraptionsGetsHandledLocally$0(contraption = contraptionEntity.getContraption(), localOrigin, localTarget, mutableResult = new MutableObject(), arg_0));
            if (predicateResult == null || predicateResult.missed()) {
                return;
            }
            BlockHitResult rayTraceResult = (BlockHitResult)mutableResult.getValue();
            InteractionHand hand = event.getHand();
            Direction face = rayTraceResult.m_82434_();
            BlockPos pos = rayTraceResult.m_82425_();
            if (!contraptionEntity.handlePlayerInteraction((Player)player, pos, face, hand)) {
                return;
            }
            AllPackets.channel.sendToServer((Object)new ContraptionInteractionPacket(contraptionEntity, hand, pos, face));
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    private static /* synthetic */ boolean lambda$rightClickingOnContraptionsGetsHandledLocally$0(Contraption contraption, Vec3 localOrigin, Vec3 localTarget, MutableObject mutableResult, BlockPos p) {
        StructureTemplate.StructureBlockInfo blockInfo = contraption.getBlocks().get(p);
        if (blockInfo == null) {
            return false;
        }
        BlockState state = blockInfo.f_74676_;
        VoxelShape raytraceShape = state.m_60808_((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_.m_7495_());
        if (raytraceShape.m_83281_()) {
            return false;
        }
        BlockHitResult rayTrace = raytraceShape.m_83220_(localOrigin, localTarget, p);
        if (rayTrace != null) {
            mutableResult.setValue((Object)rayTrace);
            return true;
        }
        return false;
    }
}

