/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.IRegistryDelegate;

public class FurnaceEngineInteractions {
    private static final Map<IRegistryDelegate<Block>, InteractionHandler> HANDLERS = new HashMap<IRegistryDelegate<Block>, InteractionHandler>();
    private static final InteractionHandler DEFAULT_HANDLER = new InteractionHandler(){};

    public static void registerHandler(IRegistryDelegate<Block> block, InteractionHandler handler) {
        HANDLERS.put(block, handler);
    }

    public static InteractionHandler getHandler(IRegistryDelegate<Block> delegate) {
        return HANDLERS.getOrDefault(delegate, DEFAULT_HANDLER);
    }

    public static InteractionHandler getHandler(BlockState state) {
        return FurnaceEngineInteractions.getHandler((IRegistryDelegate<Block>)state.m_60734_().delegate);
    }

    public static void registerDefaults() {
        FurnaceEngineInteractions.registerHandler((IRegistryDelegate<Block>)Blocks.f_50620_.delegate, InteractionHandler.ofCustomSpeedModifier(state -> Float.valueOf(2.0f)));
    }

    public static interface InteractionHandler {
        default public HeatSource getHeatSource(BlockState state) {
            if (state.m_60734_() instanceof AbstractFurnaceBlock && state.m_61138_((Property)AbstractFurnaceBlock.f_48684_)) {
                if (((Boolean)state.m_61143_((Property)AbstractFurnaceBlock.f_48684_)).booleanValue()) {
                    return HeatSource.ACTIVE;
                }
                return HeatSource.VALID;
            }
            return HeatSource.EMPTY;
        }

        default public float getSpeedModifier(BlockState state) {
            return 1.0f;
        }

        public static InteractionHandler of(final Function<BlockState, HeatSource> heatSourceFunc, final Function<BlockState, Float> speedModifierFunc) {
            return new InteractionHandler(){

                @Override
                public HeatSource getHeatSource(BlockState state) {
                    return (HeatSource)((Object)heatSourceFunc.apply(state));
                }

                @Override
                public float getSpeedModifier(BlockState state) {
                    return ((Float)speedModifierFunc.apply(state)).floatValue();
                }
            };
        }

        public static InteractionHandler ofCustomHeatSource(final Function<BlockState, HeatSource> heatSourceFunc) {
            return new InteractionHandler(){

                @Override
                public HeatSource getHeatSource(BlockState state) {
                    return (HeatSource)((Object)heatSourceFunc.apply(state));
                }
            };
        }

        public static InteractionHandler ofCustomSpeedModifier(final Function<BlockState, Float> speedModifierFunc) {
            return new InteractionHandler(){

                @Override
                public float getSpeedModifier(BlockState state) {
                    return ((Float)speedModifierFunc.apply(state)).floatValue();
                }
            };
        }
    }

    public static enum HeatSource {
        EMPTY,
        VALID,
        ACTIVE;


        public boolean isEmpty() {
            return this == EMPTY;
        }

        public boolean isValid() {
            return this != EMPTY;
        }

        public boolean isActive() {
            return this == ACTIVE;
        }
    }
}

