/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crank;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.content.contraptions.base.SingleRotatingInstance;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.content.contraptions.components.crank.HandCrankTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class HandCrankInstance
extends SingleRotatingInstance
implements DynamicInstance {
    private final HandCrankTileEntity tile;
    private ModelData crank;
    private Direction facing;

    public HandCrankInstance(MaterialManager modelManager, HandCrankTileEntity tile) {
        super(modelManager, tile);
        this.tile = tile;
        Block block = this.blockState.m_60734_();
        PartialModel renderedHandle = null;
        if (block instanceof HandCrankBlock) {
            renderedHandle = ((HandCrankBlock)block).getRenderedHandle();
        }
        if (renderedHandle == null) {
            return;
        }
        this.facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction opposite = this.facing.m_122424_();
        Instancer model = this.getTransformMaterial().getModel(renderedHandle, this.blockState, opposite);
        this.crank = (ModelData)model.createInstance();
        this.rotateCrank();
    }

    public void beginFrame() {
        if (this.crank == null) {
            return;
        }
        this.rotateCrank();
    }

    private void rotateCrank() {
        Direction.Axis axis = this.facing.m_122434_();
        float angle = (this.tile.independentAngle + AnimationTickHolder.getPartialTicks() * this.tile.chasingVelocity) / 360.0f;
        ((ModelData)((ModelData)((ModelData)this.crank.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotate(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), angle)).unCentre();
    }

    @Override
    public void remove() {
        super.remove();
        if (this.crank != null) {
            this.crank.delete();
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        if (this.crank != null) {
            this.relight(this.pos, new FlatLit[]{this.crank});
        }
    }
}

