/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.google.gson.JsonObject;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCraftingInventory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class MechanicalCraftingRecipe
extends ShapedRecipe {
    private boolean acceptMirrored;

    public MechanicalCraftingRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, boolean acceptMirrored) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.acceptMirrored = acceptMirrored;
    }

    private static MechanicalCraftingRecipe fromShaped(ShapedRecipe recipe, boolean acceptMirrored) {
        return new MechanicalCraftingRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_(), acceptMirrored);
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        if (!(inv instanceof MechanicalCraftingInventory)) {
            return false;
        }
        if (this.acceptsMirrored()) {
            return super.m_5818_(inv, worldIn);
        }
        for (int i = 0; i <= inv.m_39347_() - this.m_44220_(); ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.m_44221_(); ++j) {
                if (!this.matchesSpecific(inv, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesSpecific(CraftingContainer inv, int p_77573_2_, int p_77573_3_) {
        NonNullList ingredients = this.m_7527_();
        int width = this.m_44220_();
        int height = this.m_44221_();
        for (int i = 0; i < inv.m_39347_(); ++i) {
            for (int j = 0; j < inv.m_39346_(); ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < width && l < height) {
                    ingredient = (Ingredient)ingredients.get(k + l * width);
                }
                if (ingredient.test(inv.m_8020_(i + j * inv.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public RecipeType<?> m_6671_() {
        return AllRecipeTypes.MECHANICAL_CRAFTING.getType();
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return AllRecipeTypes.MECHANICAL_CRAFTING.getSerializer();
    }

    public boolean acceptsMirrored() {
        return this.acceptMirrored;
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public ShapedRecipe m_6729_(ResourceLocation recipeId, JsonObject json) {
            return MechanicalCraftingRecipe.fromShaped(super.m_6729_(recipeId, json), GsonHelper.m_13855_((JsonObject)json, (String)"acceptMirrored", (boolean)true));
        }

        public ShapedRecipe m_8005_(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return MechanicalCraftingRecipe.fromShaped(super.m_8005_(recipeId, buffer), buffer.readBoolean() && buffer.readBoolean());
        }

        public void m_6178_(FriendlyByteBuf p_199427_1_, ShapedRecipe p_199427_2_) {
            super.m_6178_(p_199427_1_, p_199427_2_);
            if (p_199427_2_ instanceof MechanicalCraftingRecipe) {
                p_199427_1_.writeBoolean(true);
                p_199427_1_.writeBoolean(((MechanicalCraftingRecipe)p_199427_2_).acceptsMirrored());
            } else {
                p_199427_1_.writeBoolean(false);
            }
        }
    }
}

