/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedSaw;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;

public class BlockCuttingCategory
extends CreateRecipeCategory<CondensedBlockCuttingRecipe> {
    private AnimatedSaw saw = new AnimatedSaw();

    public BlockCuttingCategory(Item symbol) {
        super(BlockCuttingCategory.doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_SAW.get(), (ItemLike)symbol), BlockCuttingCategory.emptyBackground(177, 70));
    }

    public Class<? extends CondensedBlockCuttingRecipe> getRecipeClass() {
        return CondensedBlockCuttingRecipe.class;
    }

    public void setIngredients(CondensedBlockCuttingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.m_7527_());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputs());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CondensedBlockCuttingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 4, 4);
        itemStacks.set(0, Arrays.asList(((Ingredient)recipe.m_7527_().get(0)).m_43908_()));
        List<List<ItemStack>> results = recipe.getCondensedOutputs();
        for (int outputIndex = 0; outputIndex < results.size(); ++outputIndex) {
            int xOffset = outputIndex % 5 * 19;
            int yOffset = outputIndex / 5 * -19;
            itemStacks.init(outputIndex + 1, false, 77 + xOffset, 47 + yOffset);
            itemStacks.set(outputIndex + 1, results.get(outputIndex));
        }
    }

    public void draw(CondensedBlockCuttingRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.render(matrixStack, 4, 4);
        int size = Math.min(recipe.getOutputs().size(), 15);
        for (int i = 0; i < size; ++i) {
            int xOffset = i % 5 * 19;
            int yOffset = i / 5 * -19;
            AllGuiTextures.JEI_SLOT.render(matrixStack, 77 + xOffset, 47 + yOffset);
        }
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 31, 6);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 16, 50);
        this.saw.draw(matrixStack, 33, 37);
    }

    public static class CondensedBlockCuttingRecipe
    extends StonecutterRecipe {
        List<ItemStack> outputs = new ArrayList<ItemStack>();

        public CondensedBlockCuttingRecipe(Ingredient ingredient) {
            super(new ResourceLocation(""), "", ingredient, ItemStack.f_41583_);
        }

        public void addOutput(ItemStack stack) {
            this.outputs.add(stack);
        }

        public List<ItemStack> getOutputs() {
            return this.outputs;
        }

        public List<List<ItemStack>> getCondensedOutputs() {
            ArrayList<List<ItemStack>> result = new ArrayList<List<ItemStack>>();
            int index = 0;
            boolean firstPass = true;
            for (ItemStack itemStack : this.outputs) {
                if (firstPass) {
                    result.add(new ArrayList());
                }
                ((List)result.get(index)).add(itemStack);
                if (++index < 15) continue;
                index = 0;
                firstPass = false;
            }
            return result;
        }

        public static List<CondensedBlockCuttingRecipe> condenseRecipes(List<Recipe<?>> stoneCuttingRecipes) {
            ArrayList<CondensedBlockCuttingRecipe> condensed = new ArrayList<CondensedBlockCuttingRecipe>();
            block0: for (Recipe<?> recipe : stoneCuttingRecipes) {
                Ingredient i1 = (Ingredient)recipe.m_7527_().get(0);
                for (CondensedBlockCuttingRecipe condensedRecipe : condensed) {
                    if (!ItemHelper.matchIngredients(i1, (Ingredient)condensedRecipe.m_7527_().get(0))) continue;
                    condensedRecipe.addOutput(recipe.m_8043_());
                    continue block0;
                }
                CondensedBlockCuttingRecipe cr = new CondensedBlockCuttingRecipe(i1);
                cr.addOutput(recipe.m_8043_());
                condensed.add(cr);
            }
            return condensed;
        }

        public boolean m_5598_() {
            return true;
        }
    }
}

