/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.block.render.SpriteShifter;
import com.simibubi.create.foundation.utility.Couple;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.properties.WoodType;

public class AllSpriteShifts {
    private static final Map<WoodType, CTSpriteShiftEntry> WOODEN_WINDOWS = new IdentityHashMap<WoodType, CTSpriteShiftEntry>();
    public static final Map<DyeColor, SpriteShiftEntry> DYED_BELTS = new IdentityHashMap<DyeColor, SpriteShiftEntry>();
    public static final Map<DyeColor, SpriteShiftEntry> DYED_OFFSET_BELTS = new IdentityHashMap<DyeColor, SpriteShiftEntry>();
    public static final Map<DyeColor, SpriteShiftEntry> DYED_DIAGONAL_BELTS = new IdentityHashMap<DyeColor, SpriteShiftEntry>();
    public static final CTSpriteShiftEntry FRAMED_GLASS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "palettes/framed_glass", "palettes/framed_glass");
    public static final CTSpriteShiftEntry HORIZONTAL_FRAMED_GLASS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.HORIZONTAL_KRYPPERS, "palettes/framed_glass", "palettes/horizontal_framed_glass");
    public static final CTSpriteShiftEntry VERTICAL_FRAMED_GLASS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.VERTICAL, "palettes/framed_glass", "palettes/vertical_framed_glass");
    public static final CTSpriteShiftEntry ORNATE_IRON_WINDOW = AllSpriteShifts.vertical("palettes/ornate_iron_window");
    public static final CTSpriteShiftEntry CRAFTER_FRONT = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "crafter_top", "brass_casing");
    public static final CTSpriteShiftEntry CRAFTER_SIDE = AllSpriteShifts.vertical("crafter_side");
    public static final CTSpriteShiftEntry CRAFTER_OTHERSIDE = AllSpriteShifts.horizontal("crafter_side");
    public static final CTSpriteShiftEntry ANDESITE_ENCASED_COGWHEEL_SIDE = AllSpriteShifts.vertical("andesite_encased_cogwheel_side");
    public static final CTSpriteShiftEntry ANDESITE_ENCASED_COGWHEEL_OTHERSIDE = AllSpriteShifts.horizontal("andesite_encased_cogwheel_side");
    public static final CTSpriteShiftEntry BRASS_ENCASED_COGWHEEL_SIDE = AllSpriteShifts.vertical("brass_encased_cogwheel_side");
    public static final CTSpriteShiftEntry BRASS_ENCASED_COGWHEEL_OTHERSIDE = AllSpriteShifts.horizontal("brass_encased_cogwheel_side");
    public static final CTSpriteShiftEntry ANDESITE_CASING = AllSpriteShifts.omni("andesite_casing");
    public static final CTSpriteShiftEntry BRASS_CASING = AllSpriteShifts.omni("brass_casing");
    public static final CTSpriteShiftEntry COPPER_CASING = AllSpriteShifts.omni("copper_casing");
    public static final CTSpriteShiftEntry SHADOW_STEEL_CASING = AllSpriteShifts.omni("shadow_steel_casing");
    public static final CTSpriteShiftEntry REFINED_RADIANCE_CASING = AllSpriteShifts.omni("refined_radiance_casing");
    public static final CTSpriteShiftEntry CREATIVE_CASING = CTSpriteShifter.getCT(CTSpriteShifter.CTType.CROSS, "creative_casing");
    public static final CTSpriteShiftEntry CHASSIS_SIDE = AllSpriteShifts.omni("linear_chassis_side");
    public static final CTSpriteShiftEntry SECONDARY_CHASSIS_SIDE = AllSpriteShifts.omni("secondary_linear_chassis_side");
    public static final CTSpriteShiftEntry CHASSIS = AllSpriteShifts.omni("linear_chassis_end");
    public static final CTSpriteShiftEntry CHASSIS_STICKY = AllSpriteShifts.omni("linear_chassis_end_sticky");
    public static final CTSpriteShiftEntry BRASS_TUNNEL_TOP = AllSpriteShifts.vertical("brass_tunnel_top");
    public static final CTSpriteShiftEntry FLUID_TANK = CTSpriteShifter.getCT(CTSpriteShifter.CTType.CROSS, "fluid_tank");
    public static final CTSpriteShiftEntry CREATIVE_FLUID_TANK = CTSpriteShifter.getCT(CTSpriteShifter.CTType.CROSS, "creative_fluid_tank");
    public static final Couple<CTSpriteShiftEntry> VAULT_TOP = AllSpriteShifts.vault("top");
    public static final Couple<CTSpriteShiftEntry> VAULT_FRONT = AllSpriteShifts.vault("front");
    public static final Couple<CTSpriteShiftEntry> VAULT_SIDE = AllSpriteShifts.vault("side");
    public static final Couple<CTSpriteShiftEntry> VAULT_BOTTOM = AllSpriteShifts.vault("bottom");
    public static final SpriteShiftEntry BELT = SpriteShifter.get("block/belt", "block/belt_scroll");
    public static final SpriteShiftEntry BELT_OFFSET = SpriteShifter.get("block/belt_offset", "block/belt_scroll");
    public static final SpriteShiftEntry BELT_DIAGONAL = SpriteShifter.get("block/belt_diagonal", "block/belt_diagonal_scroll");
    public static final SpriteShiftEntry ANDESIDE_BELT_CASING = SpriteShifter.get("block/brass_casing_belt", "block/andesite_casing_belt");
    public static final SpriteShiftEntry CRAFTER_THINGIES = SpriteShifter.get("block/crafter_thingies", "block/crafter_thingies");

    private static void populateMaps() {
        WoodType[] supportedWoodTypes = new WoodType[]{WoodType.f_61830_, WoodType.f_61831_, WoodType.f_61832_, WoodType.f_61833_, WoodType.f_61834_, WoodType.f_61835_, WoodType.f_61836_, WoodType.f_61837_};
        Arrays.stream(supportedWoodTypes).forEach(woodType -> WOODEN_WINDOWS.put((WoodType)woodType, AllSpriteShifts.vertical("palettes/" + woodType.m_61846_() + "_window")));
        for (DyeColor color : DyeColor.values()) {
            String id = color.m_7912_();
            DYED_BELTS.put(color, SpriteShifter.get("block/belt", "block/belt/" + id + "_scroll"));
            DYED_OFFSET_BELTS.put(color, SpriteShifter.get("block/belt_offset", "block/belt/" + id + "_scroll"));
            DYED_DIAGONAL_BELTS.put(color, SpriteShifter.get("block/belt_diagonal", "block/belt/" + id + "_diagonal_scroll"));
        }
    }

    private static Couple<CTSpriteShiftEntry> vault(String name) {
        String prefixed = "vault_" + name;
        return Couple.createWithContext(b -> CTSpriteShifter.getCT(CTSpriteShifter.CTType.CROSS, prefixed, (String)(b != false ? prefixed : prefixed + "_large")));
    }

    private static CTSpriteShiftEntry omni(String name) {
        return CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, name);
    }

    private static CTSpriteShiftEntry horizontal(String name) {
        return CTSpriteShifter.getCT(CTSpriteShifter.CTType.HORIZONTAL, name);
    }

    private static CTSpriteShiftEntry vertical(String name) {
        return CTSpriteShifter.getCT(CTSpriteShifter.CTType.VERTICAL, name);
    }

    public static CTSpriteShiftEntry getWoodenWindow(WoodType woodType) {
        return WOODEN_WINDOWS.get(woodType);
    }

    static {
        AllSpriteShifts.populateMaps();
    }
}

