/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class DisplayUtil
extends GuiComponent {
    private static final DisplayUtil DH = new DisplayUtil();
    private static final String NUM_SUFFIXES = "kmbt";
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.renderStack(x, y, stack, stack.m_41613_() > 1 ? DisplayUtil.shortHandNumber(stack.m_41613_()) : "");
    }

    public static void renderStack(int x, int y, ItemStack stack, String countText) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.m_91291_().m_115123_(stack, x, y);
            CLIENT.m_91291_().m_115174_(DisplayUtil.CLIENT.f_91062_, stack, x, y, countText);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            ExceptionUtil.dump(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    private static String shortHandNumber(int number) {
        if (number < 1000) {
            return "" + number;
        }
        int exp = (int)(Math.log(number) / Math.log(1000.0));
        return String.format("%.1f%c", (double)number / Math.pow(1000.0, exp), Character.valueOf(NUM_SUFFIXES.charAt(exp - 1)));
    }

    public static void enable3DRender() {
        Lighting.m_84931_();
        RenderSystem.m_69482_();
    }

    public static void enable2DRender() {
        Lighting.m_84930_();
        RenderSystem.m_69465_();
    }

    public static void drawGradientRect(PoseStack matrices, int x, int y, int w, int h, int startColor, int endColor) {
        DH.m_93179_(matrices, x, y, x + w, y + h, startColor, endColor);
    }

    public static void drawTexturedModalRect(PoseStack matrices, int x, int y, int textureX, int textureY, int width, int height, int tw, int th) {
        DisplayUtil.m_93160_((PoseStack)matrices, (int)x, (int)y, (int)width, (int)height, (float)textureX, (float)textureY, (int)tw, (int)th, (int)256, (int)256);
    }
}

