/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.component;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public enum PlantComponent implements IBlockComponentProvider
{
    INSTANCE;

    static final ItemStack WHEAT_STACK;
    static final ItemStack BEETROOT_STACK;

    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.addPair((Component)new TranslatableComponent("tooltip.waila.crop_growth"), (Component)new TextComponent(String.format("%.0f%%", Float.valueOf(growthValue))));
        } else {
            tooltip.addPair((Component)new TranslatableComponent("tooltip.waila.crop_growth"), (Component)new TranslatableComponent("tooltip.waila.crop_mature"));
        }
    }

    @Override
    public ItemStack getDisplayItem(IBlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() == Blocks.f_50092_) {
            return WHEAT_STACK;
        }
        if (accessor.getBlock() == Blocks.f_50444_) {
            return BEETROOT_STACK;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.CROP_PROGRESS)) {
            Block block = accessor.getBlock();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)crop.m_7959_())).intValue() / (float)crop.m_7419_());
            } else if (accessor.getBlock() == Blocks.f_50190_ || accessor.getBlock() == Blocks.f_50189_) {
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)BlockStateProperties.f_61409_)).intValue() / 7.0f);
            } else if (accessor.getBlock() == Blocks.f_50262_) {
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)BlockStateProperties.f_61406_)).intValue() / 2.0f);
            } else if (accessor.getBlock() == Blocks.f_50685_) {
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)BlockStateProperties.f_61407_)).intValue() / 3.0f);
            } else if (accessor.getBlock() == Blocks.f_50200_) {
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)BlockStateProperties.f_61407_)).intValue() / 3.0f);
            }
        }
    }

    static {
        WHEAT_STACK = new ItemStack((ItemLike)Items.f_42405_);
        BEETROOT_STACK = new ItemStack((ItemLike)Items.f_42732_);
    }
}

