/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Dimension;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;

public class HealthRenderer
implements ITooltipRenderer {
    @Override
    public Dimension getSize(CompoundTag tag, ICommonAccessor accessor) {
        float maxHearts = IWailaConfig.get().getGeneral().getMaxHeartsPerLine();
        float maxHealth = tag.m_128457_("max");
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        int lineCount = (int)Math.ceil(maxHealth / maxHearts);
        return new Dimension(8 * heartsPerLine, 10 * lineCount);
    }

    @Override
    public void draw(PoseStack matrices, CompoundTag tag, ICommonAccessor accessor, int x, int y) {
        float maxHearts = IWailaConfig.get().getGeneral().getMaxHeartsPerLine();
        float health = tag.m_128457_("health");
        float maxHealth = tag.m_128457_("max");
        int heartCount = Mth.m_14167_((float)maxHealth);
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        int xOffset = 0;
        for (int i = 1; i <= heartCount; ++i) {
            if (i <= Mth.m_14143_((float)health)) {
                Texture.HEART.render(matrices, x + xOffset, y);
                xOffset += 8;
            }
            if ((float)i > health && (float)i < health + 1.0f) {
                Texture.HALF_HEART.render(matrices, x + xOffset, y);
                xOffset += 8;
            }
            if ((float)i >= health + 1.0f) {
                Texture.EMPTY_HEART.render(matrices, x + xOffset, y);
                xOffset += 8;
            }
            if (i % heartsPerLine != 0) continue;
            y += 10;
            xOffset = 0;
        }
    }

    static enum Texture {
        HEART(52, 0, 9, 9, 16, 0, 9, 9, "a"),
        HALF_HEART(61, 0, 9, 9, 16, 0, 9, 9, "b"),
        EMPTY_HEART(16, 0, 9, 9, -1, -1, -1, -1, "c");

        final int u;
        final int v;
        final int su;
        final int sv;
        final int bu;
        final int bv;
        final int bsu;
        final int bsv;
        final String symbol;

        private Texture(int u, int v, int su, int sv, int bu, int bv, int bsu, int bsv, String symbol) {
            this.u = u;
            this.v = v;
            this.su = su;
            this.sv = sv;
            this.bu = bu;
            this.bv = bv;
            this.bsu = bsu;
            this.bsv = bsv;
            this.symbol = symbol;
        }

        void render(PoseStack matrices, int x, int y) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            DisplayUtil.bindTexture(GuiComponent.f_93098_);
            RenderSystem.m_69478_();
            if (this.bu != -1) {
                DisplayUtil.drawTexturedModalRect(matrices, x, y, this.bu, this.bv, 8, 8, this.bsu, this.bsv);
            }
            DisplayUtil.drawTexturedModalRect(matrices, x, y, this.u, this.v, 8, 8, this.su, this.sv);
            RenderSystem.m_69461_();
        }
    }
}

