/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.component;

import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.plugin.core.config.Options;
import mcp.mobius.waila.plugin.core.renderer.Renderers;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public enum EntityComponent implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    public ItemStack getDisplayItem(IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        if (entity instanceof Mob) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = entity.m_142340_();
        return stack != null ? stack : ItemStack.f_41583_;
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        IWailaConfig.Formatting formatting = IWailaConfig.get().getFormatting();
        tooltip.set(WailaConstants.OBJECT_NAME_TAG, (Component)new TextComponent(formatting.formatEntityName(entity.m_5446_().getString())));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.set(WailaConstants.REGISTRY_NAME_TAG, (Component)new TextComponent(formatting.formatRegistryName(Registry.f_122826_.m_7981_((Object)entity.m_6095_()))));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object t;
        if (config.getBoolean(Options.ENTITY_HEALTH) && (t = accessor.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)t;
            float health = living.m_21223_();
            float maxHealth = living.m_21233_();
            if (living.m_21233_() > (float)IWailaConfig.get().getGeneral().getMaxHealthForRender()) {
                tooltip.add((Component)new TranslatableComponent("tooltip.waila.health", new Object[]{String.format("%.2f", Float.valueOf(health)), String.format("%.2f", Float.valueOf(maxHealth))}));
            } else {
                CompoundTag healthData = new CompoundTag();
                healthData.m_128350_("health", health / 2.0f);
                healthData.m_128350_("max", maxHealth / 2.0f);
                tooltip.addDrawable(Renderers.RENDER_ENTITY_HEALTH, healthData);
            }
        }
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.set(WailaConstants.MOD_NAME_TAG, (Component)new TextComponent(IWailaConfig.get().getFormatting().formatModName(IModInfo.get(accessor.getEntity()).getName())));
        }
    }
}

