/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class PacketIo<I, O> {
    public static final PacketIo<CompoundTag, CompoundTag> ReceiveData = new PacketIo<CompoundTag, CompoundTag>(){

        @Override
        public void write(FriendlyByteBuf buf, CompoundTag tag) {
            buf.m_130079_(tag);
        }

        @Override
        protected CompoundTag apply(FriendlyByteBuf buf) {
            return buf.m_130260_();
        }
    };
    public static final PacketIo<Void, Void> GenerateClientDump = new PacketIo<Void, Void>(){

        @Override
        public void write(FriendlyByteBuf buf, Void unused) {
        }

        @Override
        protected Void apply(FriendlyByteBuf buf) {
            return null;
        }
    };
    public static final PacketIo<Entity, Integer> RequestEntity = new PacketIo<Entity, Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Entity entity) {
            buf.writeInt(entity.m_142049_());
        }

        @Override
        protected Integer apply(FriendlyByteBuf buf) {
            return buf.readInt();
        }
    };
    public static final PacketIo<BlockEntity, BlockPos> RequestBlock = new PacketIo<BlockEntity, BlockPos>(){

        @Override
        public void write(FriendlyByteBuf buf, BlockEntity blockEntity) {
            buf.m_130064_(blockEntity.m_58899_());
        }

        @Override
        protected BlockPos apply(FriendlyByteBuf buf) {
            return buf.m_130135_();
        }
    };
    public static final PacketIo<PluginConfig, Map<ResourceLocation, Object>> SendConfig = new PacketIo<PluginConfig, Map<ResourceLocation, Object>>(){
        static final int BOOL = 0;
        static final int INT = 1;
        static final int DOUBLE = 2;
        static final int STRING = 3;

        @Override
        public void write(FriendlyByteBuf buf, PluginConfig config) {
            Set<ConfigEntry<Object>> entries = config.getSyncableConfigs();
            buf.m_130130_(entries.size());
            for (ConfigEntry<Object> e : entries) {
                buf.m_130085_(e.getId());
                Object v = e.getValue();
                if (v instanceof Boolean) {
                    Boolean z = (Boolean)v;
                    buf.m_130130_(0);
                    buf.writeBoolean(z.booleanValue());
                    continue;
                }
                if (v instanceof Integer) {
                    Integer i = (Integer)v;
                    buf.m_130130_(1);
                    buf.m_130130_(i.intValue());
                    continue;
                }
                if (v instanceof Double) {
                    Double d = (Double)v;
                    buf.m_130130_(2);
                    buf.writeDouble(d.doubleValue());
                    continue;
                }
                if (v instanceof String) {
                    String str = (String)v;
                    buf.m_130130_(3);
                    buf.m_130070_(str);
                    continue;
                }
                if (!(v instanceof Enum)) continue;
                Enum en = (Enum)v;
                buf.m_130130_(3);
                buf.m_130070_(en.name());
            }
        }

        @Override
        protected Map<ResourceLocation, Object> apply(FriendlyByteBuf buf) {
            int size = buf.m_130242_();
            HashMap<ResourceLocation, Object> map = new HashMap<ResourceLocation, Object>();
            block6: for (int j = 0; j < size; ++j) {
                ResourceLocation id = buf.m_130281_();
                int type = buf.m_130242_();
                switch (type) {
                    case 0: {
                        map.put(id, buf.readBoolean());
                        continue block6;
                    }
                    case 1: {
                        map.put(id, buf.m_130242_());
                        continue block6;
                    }
                    case 2: {
                        map.put(id, buf.readDouble());
                        continue block6;
                    }
                    case 3: {
                        map.put(id, buf.m_130277_());
                    }
                }
            }
            return map;
        }
    };
    public static final PacketIo<BlacklistConfig, int[][]> SendBlacklist = new PacketIo<BlacklistConfig, int[][]>(){

        private <T> void writeIds(FriendlyByteBuf buf, Set<T> set, Registry<T> registry) {
            buf.m_130089_(set.stream().mapToInt(arg_0 -> registry.m_7447_(arg_0)).toArray());
        }

        @Override
        public void write(FriendlyByteBuf buf, BlacklistConfig config) {
            this.writeIds(buf, (Set)config.blocks, (Registry)Registry.f_122824_);
            this.writeIds(buf, config.blockEntityTypes, Registry.f_122830_);
            this.writeIds(buf, (Set)config.entityTypes, (Registry)Registry.f_122826_);
        }

        @Override
        protected int[][] apply(FriendlyByteBuf buf) {
            return new int[][]{buf.m_130100_(), buf.m_130100_(), buf.m_130100_()};
        }
    };

    public abstract void write(FriendlyByteBuf var1, I var2);

    public FriendlyByteBuf create(I i) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.write(buf, i);
        return buf;
    }

    protected abstract O apply(FriendlyByteBuf var1);

    public <R> R apply(FriendlyByteBuf buf, Function<O, R> fun) {
        return fun.apply(this.apply(buf));
    }

    public void consume(FriendlyByteBuf buf, Consumer<O> fun) {
        fun.accept(this.apply(buf));
    }
}

