/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.gson.Gson;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.data.DataAccessor;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.CommonUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PacketExecutor {
    private static final Gson GSON = new Gson();

    public static void generateClientDump() {
        Path path = CommonUtil.gameDir.resolve(".waila/WailaClientDump.md");
        if (DumpGenerator.generate(path)) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("command.waila.client_dump_success", new Object[]{path}), false);
        }
    }

    public static void receiveData(CompoundTag tag) {
        DataAccessor.INSTANCE.setServerData(tag);
    }

    public static void sendConfig(Map<ResourceLocation, Object> map) {
        for (ConfigEntry<Object> config : PluginConfig.INSTANCE.getSyncableConfigs()) {
            Object object;
            ResourceLocation id = config.getId();
            Object defaultValue = config.getDefaultValue();
            if (defaultValue instanceof Enum) {
                Enum e = (Enum)defaultValue;
                object = Enum.valueOf(e.getDeclaringClass(), (String)map.getOrDefault(id, e.name()));
            } else {
                object = map.getOrDefault(id, defaultValue);
            }
            Object syncedValue = object;
            config.setValue(syncedValue);
        }
        CommonUtil.LOGGER.info("Received config from the server: {}", (Object)GSON.toJson(map));
    }

    public static void sendBlacklist(int[][] rawIds) {
        BlacklistConfig blacklist = Waila.blacklistConfig.get();
        PacketExecutor.setBlackList(rawIds[0], blacklist.blocks, Registry.f_122824_);
        PacketExecutor.setBlackList(rawIds[1], blacklist.blockEntityTypes, Registry.f_122830_);
        PacketExecutor.setBlackList(rawIds[2], blacklist.entityTypes, Registry.f_122826_);
    }

    public static void requestEntity(ServerPlayer player, int entityId, Consumer<CompoundTag> consumer) {
        Registrar registrar = Registrar.INSTANCE;
        Level world = player.f_19853_;
        Entity entity = world.m_6815_(entityId);
        if (entity == null) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        registrar.entityData.get(entity).forEach(provider -> provider.appendServerData(tag, player, world, entity));
        tag.m_128405_("WailaEntityID", entity.m_142049_());
        consumer.accept(tag);
    }

    public static void requestBlockEntity(ServerPlayer player, BlockPos pos, Consumer<CompoundTag> consumer) {
        Registrar registrar = Registrar.INSTANCE;
        Level world = player.f_19853_;
        if (!world.m_46805_(pos)) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity == null) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        CompoundTag tag = new CompoundTag();
        registrar.blockData.get(blockEntity).forEach(provider -> provider.appendServerData(tag, player, world, blockEntity));
        registrar.blockData.get(state.m_60734_()).forEach(provider -> provider.appendServerData(tag, player, world, blockEntity));
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("y", pos.m_123342_());
        tag.m_128405_("z", pos.m_123343_());
        tag.m_128359_("id", Registry.f_122830_.m_7981_((Object)blockEntity.m_58903_()).toString());
        consumer.accept(tag);
    }

    private static <T> void setBlackList(int[] ids, Set<T> set, Registry<T> registry) {
        for (int id : ids) {
            set.add(registry.m_7942_(id));
        }
    }
}

