/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.text2speech.Narrator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.data.DataAccessor;
import mcp.mobius.waila.event.EventCanceller;
import mcp.mobius.waila.hud.Tooltip;
import mcp.mobius.waila.hud.component.DrawableComponent;
import mcp.mobius.waila.hud.component.PairComponent;
import mcp.mobius.waila.hud.component.TaggedComponent;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;

public class TooltipHandler {
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Object2IntOpenHashMap<Component> LINE_HEIGHT = new Object2IntOpenHashMap();
    private static final Supplier<Rectangle> RENDER_RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Rectangle> RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    private static final String COLON = ": ";
    static boolean shouldRender = false;
    private static String lastNarration = "";
    private static ItemStack stack = ItemStack.f_41583_;
    private static int topOffset;
    private static int colonOffset;
    private static int colonWidth;
    private static boolean started;

    public static void beginBuild() {
        TOOLTIP.clear();
        LINE_HEIGHT.clear();
        stack = ItemStack.f_41583_;
        topOffset = 0;
        colonOffset = 0;
        colonWidth = Minecraft.m_91087_().f_91062_.m_92895_(COLON);
        started = true;
    }

    public static void add(Tooltip tooltip) {
        Preconditions.checkState((boolean)started);
        for (Component component : tooltip) {
            if (component instanceof TaggedComponent) {
                TaggedComponent tagged = (TaggedComponent)component;
                TOOLTIP.set(tagged.tag, tagged.value);
                continue;
            }
            TooltipHandler.add(component);
        }
    }

    public static void add(Component line) {
        Preconditions.checkState((boolean)started);
        TOOLTIP.add(line);
        if (line instanceof PairComponent) {
            PairComponent pair = (PairComponent)line;
            colonOffset = Math.max(colonOffset, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)pair.key));
        }
    }

    public static ItemStack getStack() {
        return stack;
    }

    public static void setStack(ItemStack stack) {
        Preconditions.checkState((boolean)started);
        TooltipHandler.stack = PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_ITEM) ? stack : ItemStack.f_41583_;
    }

    public static void endBuild() {
        Preconditions.checkState((boolean)started);
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onHandleTooltip(TOOLTIP, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
        }
        TooltipHandler.narrateObjectName();
        Minecraft client = Minecraft.m_91087_();
        Window window = client.m_91268_();
        float scale = Waila.config.get().getOverlay().getScale();
        WailaConfig.Overlay.Position pos = Waila.config.get().getOverlay().getPosition();
        int w = 0;
        int h = 0;
        for (Component line : TOOLTIP) {
            int lineH;
            int lineW;
            if (line instanceof DrawableComponent) {
                Dimension size = ((DrawableComponent)line).getSize();
                lineW = size.width;
                lineH = size.height;
            } else {
                if (line instanceof PairComponent) {
                    PairComponent pair = (PairComponent)line;
                    lineW = colonOffset + colonWidth + client.f_91062_.m_92852_((FormattedText)pair.value);
                } else {
                    Component component;
                    if (line instanceof TaggedComponent) {
                        TaggedComponent tagged = (TaggedComponent)line;
                        component = tagged.value;
                    } else {
                        component = line;
                    }
                    Component value = component;
                    lineW = client.f_91062_.m_92852_((FormattedText)value);
                }
                Objects.requireNonNull(client.f_91062_);
                lineH = 9 + 1;
            }
            w = Math.max(w, lineW);
            h += lineH;
            LINE_HEIGHT.put((Object)line, lineH);
        }
        topOffset = 0;
        if (!stack.m_41619_()) {
            if (h < 16) {
                topOffset = (16 - h) / 2;
            }
            w = Math.max(w, 16) + 20;
            h = Math.max(h, 16);
        }
        w += 10;
        h += 8;
        int windowW = (int)((float)window.m_85445_() / scale);
        int windowH = (int)((float)window.m_85446_() / scale);
        IWailaConfig.Overlay.Position.Align.X anchorX = pos.getAnchor().getX();
        IWailaConfig.Overlay.Position.Align.Y anchorY = pos.getAnchor().getY();
        IWailaConfig.Overlay.Position.Align.X alignX = pos.getAlign().getX();
        IWailaConfig.Overlay.Position.Align.Y alignY = pos.getAlign().getY();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)pos.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)pos.getY();
        if (!pos.isBossBarsOverlap() && anchorX == IWailaConfig.Overlay.Position.Align.X.CENTER && anchorY == IWailaConfig.Overlay.Position.Align.Y.TOP) {
            y += (double)Math.min(client.f_91065_.m_93090_().f_93699_.size() * 19, window.m_85446_() / 3 + 2);
        }
        RECT.get().setRect(x, y, w, h);
        started = false;
    }

    public static void render(PoseStack matrices, float delta) {
        if (!shouldRender) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        ProfilerFiller profiler = client.m_91307_();
        WailaConfig config = Waila.config.get();
        profiler.m_6180_("Waila Overlay");
        float scale = config.getOverlay().getScale();
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_85841_(scale, scale, 1.0f);
        RenderSystem.m_157182_();
        matrices.m_85836_();
        DisplayUtil.enable2DRender();
        Rectangle rect = RENDER_RECT.get();
        rect.setRect(RECT.get());
        EventCanceller canceller = EventCanceller.INSTANCE;
        canceller.setCanceled(false);
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onBeforeTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE, canceller);
            if (!canceller.isCanceled()) continue;
            matrices.m_85849_();
            RenderSystem.m_69482_();
            RenderSystem.m_157191_().m_85849_();
            RenderSystem.m_157182_();
            profiler.m_7238_();
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        WailaConfig.Overlay.Color color = config.getOverlay().getColor();
        int bg = color.getBackgroundColor();
        int gradStart = color.getGradientStart();
        int gradEnd = color.getGradientEnd();
        DisplayUtil.drawGradientRect(matrices, x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + w - 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, 1, gradStart, gradStart);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h - 1, w - 1, 1, gradEnd, gradEnd);
        RenderSystem.m_69478_();
        int textX = x + (stack.m_41619_() ? 6 : 26);
        int textY = y + 6 + topOffset;
        int fontColor = color.getFontColor();
        for (Component line : TOOLTIP) {
            if (line instanceof DrawableComponent) {
                DrawableComponent drawable = (DrawableComponent)line;
                drawable.render(matrices, textX, textY, delta);
            } else if (line instanceof PairComponent) {
                PairComponent pair = (PairComponent)line;
                client.f_91062_.m_92763_(matrices, pair.key, (float)textX, (float)textY, fontColor);
                client.f_91062_.m_92750_(matrices, COLON, (float)(textX + colonOffset), (float)textY, fontColor);
                client.f_91062_.m_92763_(matrices, pair.value, (float)(textX + colonOffset + colonWidth), (float)textY, fontColor);
            } else {
                Component component;
                if (line instanceof TaggedComponent) {
                    TaggedComponent tagged = (TaggedComponent)line;
                    component = tagged.value;
                } else {
                    component = line;
                }
                Component value = component;
                client.f_91062_.m_92763_(matrices, value, (float)textX, (float)textY, color.getFontColor());
            }
            textY += LINE_HEIGHT.getInt((Object)line);
        }
        RenderSystem.m_69461_();
        matrices.m_85849_();
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onAfterTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
        }
        if (!stack.m_41619_()) {
            DisplayUtil.renderStack(x + 5, y + h / 2 - 8, stack, "");
        }
        RenderSystem.m_69482_();
        RenderSystem.m_157191_().m_85849_();
        RenderSystem.m_157182_();
        profiler.m_7238_();
    }

    private static void narrateObjectName() {
        String narrate;
        if (!shouldRender) {
            return;
        }
        Narrator narrator = NARRATOR.get();
        if (narrator.active() || !Waila.config.get().getGeneral().isEnableTextToSpeech() || Minecraft.m_91087_().f_91080_ instanceof ChatScreen) {
            return;
        }
        Component objectName = TOOLTIP.getTag(WailaConstants.OBJECT_NAME_TAG);
        if (objectName != null && !lastNarration.equalsIgnoreCase(narrate = objectName.getString())) {
            narrator.clear();
            narrator.say(narrate, true);
            lastNarration = narrate;
        }
    }

    static {
        started = false;
    }
}

