/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.Nullable;

public class InputValue<T>
extends ConfigValue<T> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("[-+]?[0-9]*$");
    public static final Predicate<String> POSITIVE_INTEGER = s -> s.matches("[0-9]*$");
    public static final Predicate<String> DECIMAL = s -> s.matches("[-+]?[0-9]*([.][0-9]*)?");
    public static final Predicate<String> POSITIVE_DECIMAL = s -> s.matches("[0-9]*([.][0-9]*)?");
    private final EditBox textField;

    public InputValue(String optionName, T value, Consumer<T> save, Predicate<String> validator) {
        this(optionName, value, null, (Consumer<Object>)save, validator);
    }

    public InputValue(String optionName, T value, Consumer<T> save) {
        this(optionName, value, save, ANY);
    }

    public InputValue(String optionName, T value, @Nullable T defaultValue, Consumer<T> save, Predicate<String> validator) {
        super(optionName, value, defaultValue, save);
        this.textField = new WatchedTextfield(this, this.client.f_91062_, 0, 0, 160, 18);
        this.textField.m_94144_(String.valueOf(value));
        this.textField.m_94153_(validator);
    }

    @Override
    protected void drawValue(PoseStack matrices, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.textField.m_94214_(x + width - this.textField.m_5711_());
        this.textField.f_93621_ = y + (height - this.textField.m_93694_()) / 2;
        this.textField.m_6305_(matrices, mouseX, mouseY, partialTicks);
    }

    @Override
    public GuiEventListener getListener() {
        return this.textField;
    }

    @Override
    protected void resetValue() {
        this.textField.m_94144_(String.valueOf(this.defaultValue));
    }

    @Override
    private void setValue(String text) {
        Object value = this.getValue();
        if (value instanceof String) {
            this.setValue(text);
        }
        try {
            if (value instanceof Integer) {
                this.setValue(Integer.valueOf(text));
            } else if (value instanceof Short) {
                this.setValue(Short.valueOf(text));
            } else if (value instanceof Byte) {
                this.setValue(Byte.valueOf(text));
            } else if (value instanceof Long) {
                this.setValue(Long.valueOf(text));
            } else if (value instanceof Double) {
                this.setValue(Double.valueOf(text));
            } else if (value instanceof Float) {
                this.setValue(Float.valueOf(text));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static class WatchedTextfield
    extends EditBox {
        public WatchedTextfield(InputValue<?> watcher, Font fontRenderer, int x, int y, int width, int height) {
            super(fontRenderer, x, y, width, height, (Component)new TextComponent(""));
            this.m_94151_(watcher::setValue);
        }

        public void m_94164_(String string) {
            String string3;
            String string2;
            int l;
            int i = Math.min(this.m_94207_(), this.f_94102_);
            int j = Math.max(this.m_94207_(), this.f_94102_);
            int k = this.f_94094_ - this.m_94155_().length() - (i - j);
            if (k < (l = (string2 = string).length())) {
                string2 = string2.substring(0, k);
                l = k;
            }
            if (this.f_94090_.test(string3 = new StringBuilder(this.m_94155_()).replace(i, j, string2).toString())) {
                this.f_94093_ = string3;
                this.m_94196_(i + l);
                this.m_94208_(this.m_94207_());
                this.m_94174_(string3);
            }
        }
    }
}

