/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import com.mojang.brigadier.CommandDispatcher;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.command.DumpCommand;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.forge.ForgeLegacyEventListener;
import mcp.mobius.waila.forge.ForgePacketSender;
import mcp.mobius.waila.forge.ForgePluginLoader;
import mcp.mobius.waila.impl.Impl;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.CommonUtil;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="waila")
@Mod.EventBusSubscriber(modid="waila", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeWaila
extends Waila {
    @SubscribeEvent
    static void setup(FMLCommonSetupEvent event) {
        String[] mods;
        clientSide = FMLLoader.getDist() == Dist.CLIENT;
        blockBlacklist = BlockTags.createOptional((ResourceLocation)CommonUtil.id("blacklist"));
        entityBlacklist = EntityTypeTags.createOptional((ResourceLocation)CommonUtil.id("blacklist"));
        CommonUtil.gameDir = FMLPaths.GAMEDIR.get();
        CommonUtil.configDir = FMLPaths.CONFIGDIR.get();
        ForgeWaila.init();
        packet = new ForgePacketSender();
        packet.initMain();
        Registrar.INSTANCE.addEventListener(ForgeLegacyEventListener.INSTANCE, 900);
        ModInfo.supplier = namespace -> ModList.get().getModContainerById(namespace).map(data -> new ModInfo(data.getModId(), data.getModInfo().getDisplayName()));
        for (String mod : mods = new String[]{"minecraft", "forge", "wthit", "jei"}) {
            ModList.get().getModContainerById(mod).map(ModContainer::getModInfo).ifPresent(m -> DumpGenerator.VERSIONS.put(m.getDisplayName(), m.getVersion().toString()));
        }
    }

    @SubscribeEvent
    static void loadComplete(FMLLoadCompleteEvent event) {
        new ForgePluginLoader().loadPlugins();
    }

    static {
        Impl.reg(IModInfo.class, s -> ModInfo.get(s));
        Impl.reg(IModInfo.class, i -> ModInfo.get(i.m_41720_().getCreatorModId(i)));
    }

    @Mod.EventBusSubscriber(modid="waila")
    static class Subscriber {
        Subscriber() {
        }

        @SubscribeEvent
        static void serverStarting(ServerStartingEvent event) {
            PluginConfig.INSTANCE.reload();
        }

        @SubscribeEvent
        static void registerCommands(RegisterCommandsEvent event) {
            DumpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Waila.packet.sendBlacklistConfig(Waila.blacklistConfig.get(), (ServerPlayer)event.getPlayer());
            Waila.packet.sendPluginConfig(PluginConfig.INSTANCE, (ServerPlayer)event.getPlayer());
        }
    }
}

