/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import mcp.mobius.waila.api.IBlacklistConfig;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class BlacklistConfig
implements IBlacklistConfig {
    public static final int VERSION = 0;
    private int configVersion = 0;
    public int[] pluginHash = new int[]{0, 0, 0};
    public final transient LinkedHashSet<Block> blocks = new LinkedHashSet();
    public final transient LinkedHashSet<BlockEntityType<?>> blockEntityTypes = new LinkedHashSet();
    public final transient LinkedHashSet<EntityType<?>> entityTypes = new LinkedHashSet();
    private final LinkedHashSet<ResourceLocation> blockIds = new LinkedHashSet();
    private final LinkedHashSet<ResourceLocation> blockEntityTypeIds = new LinkedHashSet();
    private final LinkedHashSet<ResourceLocation> entityTypeIds = new LinkedHashSet();

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    @Override
    public boolean contains(Block block) {
        return this.blocks.contains(block);
    }

    @Override
    public boolean contains(BlockEntity blockEntity) {
        return this.blockEntityTypes.contains(blockEntity.m_58903_());
    }

    @Override
    public boolean contains(Entity entity) {
        return this.entityTypes.contains(entity.m_6095_());
    }

    public static class Adapter
    implements JsonSerializer<BlacklistConfig>,
    JsonDeserializer<BlacklistConfig> {
        private <T> void serialize(JsonObject object, String key, Registry<T> registry, Set<ResourceLocation> rlSet, Set<T> tSet) {
            JsonArray array = new JsonArray();
            for (T t : tSet) {
                rlSet.add(registry.m_7981_(t));
            }
            for (ResourceLocation rl : rlSet) {
                array.add(rl.toString());
            }
            object.add(key, (JsonElement)array);
        }

        private <T> void deserialize(JsonObject object, String key, Registry<T> registry, Set<ResourceLocation> rlSet, Set<T> tSet) {
            JsonArray array = object.getAsJsonArray(key);
            for (JsonElement element : array) {
                ResourceLocation rl = new ResourceLocation(element.getAsString());
                rlSet.add(rl);
                registry.m_6612_(rl).ifPresent(tSet::add);
            }
        }

        public JsonElement serialize(BlacklistConfig src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            this.serialize(object, "blocks", (Registry)Registry.f_122824_, (Set<ResourceLocation>)src.blockIds, (Set)src.blocks);
            this.serialize(object, "blockEntityTypes", Registry.f_122830_, src.blockEntityTypeIds, src.blockEntityTypes);
            this.serialize(object, "entityTypes", (Registry)Registry.f_122826_, (Set<ResourceLocation>)src.entityTypeIds, (Set)src.entityTypes);
            object.addProperty("configVersion", (Number)src.configVersion);
            object.add("pluginHash", context.serialize((Object)src.pluginHash));
            return object;
        }

        public BlacklistConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            BlacklistConfig res = new BlacklistConfig();
            this.deserialize(object, "blocks", (Registry)Registry.f_122824_, (Set<ResourceLocation>)res.blockIds, (Set)res.blocks);
            this.deserialize(object, "blockEntityTypes", Registry.f_122830_, res.blockEntityTypeIds, res.blockEntityTypes);
            this.deserialize(object, "entityTypes", (Registry)Registry.f_122826_, (Set<ResourceLocation>)res.entityTypeIds, (Set)res.entityTypes);
            res.configVersion = object.get("configVersion").getAsInt();
            res.pluginHash = (int[])context.deserialize(object.get("pluginHash"), int[].class);
            return res;
        }
    }
}

