/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.core.modifier;

import com.google.gson.JsonObject;
import de.melanx.morevanillalib.config.FeatureConfig;
import de.melanx.morevanillalib.data.ModTags;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class HeadDropModifier
extends LootModifier {
    public HeadDropModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity target = (Entity)context.m_78953_(LootContextParams.f_81455_);
        Entity killer = (Entity)context.m_78953_(LootContextParams.f_81458_);
        if (target instanceof AbstractSkeleton && killer instanceof LivingEntity) {
            ItemStack weapon = ((LivingEntity)killer).m_21205_();
            int looting = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44982_, (ItemStack)weapon);
            if (ModTags.Items.BONE_TOOLS.m_8110_((Object)weapon.m_41720_()) && FeatureConfig.HeadDrop.enabled && context.m_78933_().nextDouble() < FeatureConfig.HeadDrop.chance + (double)((float)looting / 100.0f)) {
                Item skull = null;
                if (target instanceof WitherSkeleton) {
                    skull = Items.f_42679_;
                } else if (target instanceof Skeleton) {
                    skull = Items.f_42678_;
                }
                if (skull != null) {
                    generatedLoot.add(new ItemStack((ItemLike)skull));
                }
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<HeadDropModifier> {
        public HeadDropModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditions) {
            return new HeadDropModifier(conditions);
        }

        public JsonObject write(HeadDropModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

