/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.core.modifier;

import com.google.gson.JsonObject;
import de.melanx.morevanillalib.config.FeatureConfig;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class ExtraDropsModifier
extends LootModifier {
    public ExtraDropsModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity killer;
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (tool == null && (killer = (Entity)context.m_78953_(LootContextParams.f_81458_)) instanceof LivingEntity) {
            tool = ((LivingEntity)killer).m_21205_();
        }
        if (tool != null && tool.m_41720_() instanceof DiggerItem && FeatureConfig.ExtraDrop.enabled && context.m_78933_().nextDouble() < FeatureConfig.ExtraDrop.chance) {
            Ingredient repairMaterial = ((DiggerItem)tool.m_41720_()).m_43314_().m_6282_();
            generatedLoot.add(repairMaterial.m_43908_()[0].m_41777_());
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ExtraDropsModifier> {
        public ExtraDropsModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditions) {
            return new ExtraDropsModifier(conditions);
        }

        public JsonObject write(ExtraDropsModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

