/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.core.modifier;

import com.google.gson.JsonObject;
import de.melanx.morevanillalib.config.FeatureConfig;
import de.melanx.morevanillalib.data.ModTags;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class DoubleDropModifier
extends LootModifier {
    public DoubleDropModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        BlockState state;
        Item tool = ((ItemStack)context.m_78953_(LootContextParams.f_81463_)).m_41720_();
        if (FeatureConfig.DoubleDrop.enabledAll && (state = (BlockState)context.m_78953_(LootContextParams.f_81461_)) != null) {
            Block block = state.m_60734_();
            ServerLevel level = context.m_78952_();
            if (ModTags.Items.DIAMOND_TOOLS.m_8110_((Object)tool)) {
                if (Tags.Blocks.ORES_DIAMOND.m_8110_((Object)block) && FeatureConfig.DoubleDrop.Diamond.enabled && level.f_46441_.nextDouble() < FeatureConfig.DoubleDrop.Diamond.chance) {
                    ItemStack drop = new ItemStack((ItemLike)Items.f_42415_);
                    generatedLoot.add(drop);
                }
            } else if (ModTags.Items.COAL_TOOLS.m_8110_((Object)tool)) {
                if (Tags.Blocks.ORES_COAL.m_8110_((Object)block) && FeatureConfig.DoubleDrop.Coal.enabled && level.f_46441_.nextDouble() < FeatureConfig.DoubleDrop.Coal.chance) {
                    ItemStack drop = new ItemStack((ItemLike)Items.f_42413_);
                    generatedLoot.add(drop);
                }
            } else if (ModTags.Items.EMERALD_TOOLS.m_8110_((Object)tool)) {
                if (Tags.Blocks.ORES_EMERALD.m_8110_((Object)block) && FeatureConfig.DoubleDrop.Emerald.enabled && level.f_46441_.nextDouble() < FeatureConfig.DoubleDrop.Emerald.chance) {
                    ItemStack drop = new ItemStack((ItemLike)Items.f_42616_);
                    generatedLoot.add(drop);
                }
            } else if (ModTags.Items.LAPIS_TOOLS.m_8110_((Object)tool)) {
                if (Tags.Blocks.ORES_LAPIS.m_8110_((Object)block) && FeatureConfig.DoubleDrop.Lapis.enabled && level.f_46441_.nextDouble() < FeatureConfig.DoubleDrop.Lapis.chance) {
                    int i = level.f_46441_.nextInt(3);
                    ItemStack drop = new ItemStack((ItemLike)Items.f_42534_, i);
                    generatedLoot.add(drop);
                }
            } else if (ModTags.Items.QUARTZ_TOOLS.m_8110_((Object)tool)) {
                if (Tags.Blocks.ORES_QUARTZ.m_8110_((Object)block) && FeatureConfig.DoubleDrop.Quartz.enabled && level.f_46441_.nextDouble() < FeatureConfig.DoubleDrop.Quartz.chance) {
                    ItemStack drop = new ItemStack((ItemLike)Items.f_42692_);
                    generatedLoot.add(drop);
                }
            } else if (ModTags.Items.REDSTONE_TOOLS.m_8110_((Object)tool) && Tags.Blocks.ORES_REDSTONE.m_8110_((Object)block) && FeatureConfig.DoubleDrop.Redstone.enabled && level.f_46441_.nextDouble() < FeatureConfig.DoubleDrop.Redstone.chance) {
                int i = level.f_46441_.nextInt(3);
                ItemStack drop = new ItemStack((ItemLike)Items.f_42451_, i);
                generatedLoot.add(drop);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DoubleDropModifier> {
        public DoubleDropModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditions) {
            return new DoubleDropModifier(conditions);
        }

        public JsonObject write(DoubleDropModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

