/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.compat;

import de.melanx.morevanillalib.MoreVanillaLib;
import de.melanx.morevanillalib.config.FeatureConfig;
import de.melanx.morevanillalib.data.ModTags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

@JeiPlugin
public class JeiCompat
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = new ResourceLocation(MoreVanillaLib.getInstance().modid, "plugin/main");

    private static void addInfoPage(IRecipeRegistration reg, Collection<Item> items, String name) {
        if (items.isEmpty()) {
            return;
        }
        TranslatableComponent component = JeiCompat.getDescKey(new ResourceLocation(MoreVanillaLib.getInstance().modid, name));
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, VanillaTypes.ITEM, new Component[]{component});
    }

    public static void addValueInfoPage(IRecipeRegistration reg, Item item, String name, Object ... values) {
        List<Item> items = Collections.singletonList(item);
        JeiCompat.addValueInfoPage(reg, items, name, values);
    }

    private static void addValueInfoPage(IRecipeRegistration reg, Collection<Item> items, String name, Object ... values) {
        if (items.isEmpty()) {
            return;
        }
        TranslatableComponent component = JeiCompat.getDescKey(new ResourceLocation(MoreVanillaLib.getInstance().modid, name), values);
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, VanillaTypes.ITEM, new Component[]{component});
    }

    private static TranslatableComponent getDescKey(ResourceLocation name) {
        return new TranslatableComponent("jei." + name.m_135827_() + "." + name.m_135815_() + ".desc");
    }

    private static TranslatableComponent getDescKey(ResourceLocation name, Object ... values) {
        return new TranslatableComponent("jei." + name.m_135827_() + "." + name.m_135815_() + ".desc", values);
    }

    private static Item getItemFromIngredient(Ingredient ingredient) {
        return ingredient.m_43908_()[0].m_41720_();
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        if (!FeatureConfig.vanillaOnly) {
            if (FeatureConfig.ExtraDrop.enabled) {
                JeiCompat.addValueInfoPage(registration, ModTags.Items.ALL_TOOLS.m_6497_(), "extra_drop", FeatureConfig.ExtraDrop.chance * 100.0);
            }
            if (FeatureConfig.ExtraDamage.enabled) {
                double extraDamageChance = FeatureConfig.ExtraDamage.chance * 100.0;
                JeiCompat.addValueInfoPage(registration, ModTags.Items.BONE_TOOLS.m_6497_(), "bone_damage", extraDamageChance, FeatureConfig.ExtraDamage.maxMultiplier * 100.0);
                JeiCompat.addValueInfoPage(registration, ModTags.Items.ENDER_TOOLS.m_6497_(), "ender_damage", extraDamageChance, FeatureConfig.ExtraDamage.maxMultiplier * 100.0);
                JeiCompat.addValueInfoPage(registration, ModTags.Items.FIERY_TOOLS.m_6497_(), "fiery_damage", extraDamageChance, FeatureConfig.ExtraDamage.maxMultiplier * 100.0);
                JeiCompat.addValueInfoPage(registration, ModTags.Items.PRISMARINE_TOOLS.m_6497_(), "prismarine_damage", extraDamageChance, FeatureConfig.ExtraDamage.maxMultiplier * 100.0);
                JeiCompat.addValueInfoPage(registration, ModTags.Items.SLIME_TOOLS.m_6497_(), "slime_damage", extraDamageChance, FeatureConfig.ExtraDamage.maxMultiplier * 100.0);
            }
            if (FeatureConfig.HeadDrop.enabled) {
                JeiCompat.addValueInfoPage(registration, ModTags.Items.BONE_TOOLS.m_6497_(), "bone_heads", FeatureConfig.HeadDrop.chance * 100.0);
            }
            if (FeatureConfig.PaperDamage.enabled) {
                JeiCompat.addValueInfoPage(registration, ModTags.Items.PAPER_TOOLS.m_6497_(), "paper_damage", FeatureConfig.PaperDamage.chance * 100.0, Float.valueOf(FeatureConfig.PaperDamage.minDamage), Float.valueOf(FeatureConfig.PaperDamage.maxDamage));
            }
            if (FeatureConfig.autoSmelt) {
                JeiCompat.addInfoPage(registration, ModTags.Items.FIERY_TOOLS.m_6497_(), "fiery_smelt");
            }
            if (FeatureConfig.glowstoneDrops) {
                JeiCompat.addInfoPage(registration, ModTags.Items.GLOWSTONE_TOOLS.m_6497_(), "glowstone_drops");
            }
        }
    }
}

