/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.api.ranged;

import de.melanx.morevanillalib.ModContent;
import de.melanx.morevanillalib.api.IBreakValidator;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BlockBreaker {
    private BlockBreaker() {
    }

    public static void breakInRadius(Level level, Player player, int radius, BlockPos originPos, IBreakValidator breakValidator) {
        if (!level.f_46443_) {
            Stream<BlockPos> brokenBlocks = BlockBreaker.getBreakBlocks(level, player, radius, EnchantmentHelper.m_44836_((Enchantment)ModContent.powerOfTheDepth, (LivingEntity)player), originPos);
            ItemStack heldItem = player.m_21205_();
            brokenBlocks.forEach(pos -> {
                BlockState state;
                if (!pos.equals((Object)originPos) && breakValidator.canBreak(state = level.m_8055_(pos))) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (player.m_150110_().f_35937_) {
                        if (state.onDestroyedByPlayer(level, pos, player, true, state.m_60819_())) {
                            state.m_60734_().m_6786_((LevelAccessor)level, pos, state);
                        }
                    } else {
                        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, player);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (event.isCanceled()) {
                            Packet packet;
                            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
                            BlockEntity tile = level.m_7702_(pos);
                            if (tile != null && (packet = tile.m_183216_()) != null) {
                                serverPlayer.f_8906_.m_141995_(packet);
                            }
                        } else {
                            heldItem.m_41720_().m_6813_(heldItem, level, state, pos, (LivingEntity)player);
                            BlockEntity blockEntity = level.m_7702_(pos);
                            state.m_60734_().m_6786_((LevelAccessor)level, pos, state);
                            state.m_60734_().m_6240_(level, player, pos, state, blockEntity, heldItem);
                            state.m_60734_().m_49805_((ServerLevel)level, pos, event.getExpToDrop());
                            level.m_7471_(pos, false);
                            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
                        }
                    }
                }
            });
        }
    }

    public static Stream<BlockPos> getBreakBlocks(Level level, Player player, int radius, BlockPos originPosition) {
        return BlockBreaker.getBreakBlocks(level, player, radius, 0, originPosition);
    }

    public static Stream<BlockPos> getBreakBlocks(Level level, Player player, int radius, int depth, BlockPos originPosition) {
        Stream<BlockPos> potentialBrokenBlocks = Stream.of(new BlockPos[0]);
        Vec3 eyePosition = player.m_146892_();
        Vec3 rotation = player.m_20252_(1.0f);
        AttributeInstance attribute = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        double reach = attribute.m_22135_();
        Vec3 combined = eyePosition.m_82520_(rotation.f_82479_ * reach, rotation.f_82480_ * reach, rotation.f_82481_ * reach);
        BlockHitResult rayTraceResult = level.m_45547_(new ClipContext(player.m_146892_(), combined, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            Direction side = rayTraceResult.m_82434_();
            boolean doX = side.m_122429_() == 0;
            boolean doY = side.m_122430_() == 0;
            boolean doZ = side.m_122431_() == 0;
            BlockPos begin = new BlockPos(doX ? -radius : 0, doY ? -radius : 0, doZ ? -radius : 0);
            BlockPos end = new BlockPos(doX ? radius : depth * -side.m_122429_(), doY ? radius : depth * -side.m_122430_(), doZ ? radius : depth * -side.m_122431_());
            return BlockPos.m_121990_((BlockPos)originPosition.m_141952_((Vec3i)begin), (BlockPos)originPosition.m_141952_((Vec3i)end));
        }
        return potentialBrokenBlocks;
    }
}

