/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.api.aiot;

import de.melanx.morevanillalib.api.IConfigurableTier;
import de.melanx.morevanillalib.config.ToolValueConfig;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public enum AIOTMaterials implements IConfigurableTier
{
    WOODEN(ToolValueConfig.AIOTs.wood, () -> Ingredient.m_43911_((Tag)ItemTags.f_13168_), true),
    STONE(ToolValueConfig.AIOTs.stone, () -> Ingredient.m_43911_((Tag)Tags.Items.COBBLESTONE), true),
    IRON(ToolValueConfig.AIOTs.iron, () -> Ingredient.m_43911_((Tag)Tags.Items.INGOTS_IRON), true),
    GOLDEN(ToolValueConfig.AIOTs.gold, () -> Ingredient.m_43911_((Tag)Tags.Items.INGOTS_GOLD), true),
    DIAMOND(ToolValueConfig.AIOTs.diamond, () -> Ingredient.m_43911_((Tag)Tags.Items.GEMS_DIAMOND), true),
    NETHERITE(ToolValueConfig.AIOTs.netherite, () -> Ingredient.m_43911_((Tag)Tags.Items.INGOTS_NETHERITE), true),
    BONE(ToolValueConfig.AIOTs.bone, () -> Ingredient.m_43911_((Tag)Tags.Items.BONES)),
    COAL(ToolValueConfig.AIOTs.coal, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_})),
    EMERALD(ToolValueConfig.AIOTs.emerald, () -> Ingredient.m_43911_((Tag)Tags.Items.GEMS_EMERALD)),
    ENDER(ToolValueConfig.AIOTs.ender, () -> Ingredient.m_43911_((Tag)Tags.Items.ENDER_PEARLS)),
    FIERY(ToolValueConfig.AIOTs.fiery, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42258_})),
    GLOWSTONE(ToolValueConfig.AIOTs.glowstone, () -> Ingredient.m_43911_((Tag)Tags.Items.DUSTS_GLOWSTONE)),
    LAPIS(ToolValueConfig.AIOTs.lapis, () -> Ingredient.m_43911_((Tag)Tags.Items.GEMS_LAPIS)),
    NETHER(ToolValueConfig.AIOTs.nether, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42095_})),
    OBSIDIAN(ToolValueConfig.AIOTs.obsidian, () -> Ingredient.m_43911_((Tag)Tags.Items.OBSIDIAN)),
    PAPER(ToolValueConfig.AIOTs.paper, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_})),
    PRISMARINE(ToolValueConfig.AIOTs.prismarine, () -> Ingredient.m_43911_((Tag)Tags.Items.DUSTS_PRISMARINE)),
    QUARTZ(ToolValueConfig.AIOTs.quartz, () -> Ingredient.m_43911_((Tag)Tags.Items.GEMS_QUARTZ)),
    REDSTONE(ToolValueConfig.AIOTs.redstone, () -> Ingredient.m_43911_((Tag)Tags.Items.DUSTS_REDSTONE)),
    SLIME(ToolValueConfig.AIOTs.slime, () -> Ingredient.m_43911_((Tag)Tags.Items.SLIMEBALLS));

    private final int harvestLevel;
    private final int durability;
    private final float speed;
    private final float attackDamageBonus;
    private final float attackSpeed;
    private final int enchantmentValue;
    private final LazyValue<Ingredient> repairMaterial;
    private final boolean vanilla;
    private final boolean morevanillatools;

    private AIOTMaterials(Tier delegate, float attackSpeed, Supplier<Ingredient> repairMaterial, boolean vanilla) {
        this.harvestLevel = delegate.m_6604_();
        this.durability = delegate.m_6609_();
        this.speed = delegate.m_6624_();
        this.attackDamageBonus = delegate.m_6631_();
        this.attackSpeed = attackSpeed;
        this.enchantmentValue = delegate.m_6601_();
        this.repairMaterial = new LazyValue(repairMaterial);
        this.vanilla = vanilla;
        this.morevanillatools = !vanilla;
    }

    private AIOTMaterials(Tier delegate, float attackSpeed, Supplier<Ingredient> repairMaterial) {
        this.harvestLevel = delegate.m_6604_();
        this.durability = delegate.m_6609_();
        this.speed = delegate.m_6624_();
        this.attackDamageBonus = delegate.m_6631_();
        this.attackSpeed = attackSpeed;
        this.enchantmentValue = delegate.m_6601_();
        this.repairMaterial = new LazyValue(repairMaterial);
        this.vanilla = false;
        this.morevanillatools = true;
    }

    private AIOTMaterials(IConfigurableTier delegate, Supplier<Ingredient> repairMaterial, boolean vanilla) {
        this.harvestLevel = delegate.m_6604_();
        this.durability = delegate.m_6609_();
        this.speed = delegate.m_6624_();
        this.attackDamageBonus = delegate.m_6631_();
        this.attackSpeed = delegate.getAttackSpeed();
        this.enchantmentValue = delegate.m_6601_();
        this.repairMaterial = new LazyValue(repairMaterial);
        this.vanilla = vanilla;
        this.morevanillatools = !vanilla;
    }

    private AIOTMaterials(IConfigurableTier delegate, Supplier<Ingredient> repairMaterial) {
        this.harvestLevel = delegate.m_6604_();
        this.durability = delegate.m_6609_();
        this.speed = delegate.m_6624_();
        this.attackDamageBonus = delegate.m_6631_();
        this.attackSpeed = delegate.getAttackSpeed();
        this.enchantmentValue = delegate.m_6601_();
        this.repairMaterial = new LazyValue(repairMaterial);
        this.vanilla = false;
        this.morevanillatools = true;
    }

    @Override
    public int m_6609_() {
        if (this.durability < 0) {
            return Integer.MAX_VALUE;
        }
        return this.durability;
    }

    @Override
    public float m_6624_() {
        return this.speed;
    }

    @Override
    public float m_6631_() {
        return this.attackDamageBonus;
    }

    @Override
    public int m_6604_() {
        return this.harvestLevel;
    }

    @Override
    public int m_6601_() {
        return this.enchantmentValue;
    }

    @Override
    @Nonnull
    public Ingredient m_6282_() {
        return (Ingredient)this.repairMaterial.get();
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public boolean isVanilla() {
        return this.vanilla;
    }
}

