/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.api.aiot;

import de.melanx.morevanillalib.api.BaseToolItem;
import de.melanx.morevanillalib.api.IConfigurableTier;
import de.melanx.morevanillalib.api.ToolType;
import de.melanx.morevanillalib.api.aiot.AIOTMaterials;
import de.melanx.morevanillalib.util.ComponentUtil;
import de.melanx.morevanillalib.util.ToolUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class AIOTBase
extends BaseToolItem {
    public AIOTBase(IConfigurableTier tier, Item.Properties properties) {
        super(tier, ToolType.AIOT, properties);
    }

    @Override
    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_.m_7454_(Items.f_42388_);
    }

    @Override
    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack item = context.m_43722_();
        boolean hoemode = AIOTBase.isHoemode(item);
        InteractionResult axeResult = InteractionResult.PASS;
        for (ToolAction action : ToolActions.DEFAULT_AXE_ACTIONS) {
            if (axeResult != InteractionResult.PASS) break;
            axeResult = ToolUtil.toolUse(context, action);
        }
        if (axeResult == InteractionResult.PASS) {
            if (hoemode) {
                return ToolUtil.toolUse(context, ToolUtil.HOE_TILL);
            }
            return ToolUtil.toolUse(context, ToolActions.SHOVEL_FLATTEN);
        }
        return axeResult;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6047_()) {
            Style dark_blue = Style.f_131099_.m_131140_(ChatFormatting.DARK_BLUE);
            Style aqua = Style.f_131099_.m_131140_(ChatFormatting.AQUA);
            MutableComponent text = ComponentUtil.getTooltip("toggleMode", new Object[0]).m_130946_(": ").m_130948_(dark_blue);
            MutableComponent pathMode = ComponentUtil.getTooltip("pathMode", Blocks.f_152481_.m_49954_().getString()).m_130948_(aqua);
            MutableComponent hoeMode = ComponentUtil.getTooltip("hoeMode", new Object[0]).m_130948_(aqua);
            if (AIOTBase.isHoemode(stack)) {
                AIOTBase.setHoemode(stack, false);
                text = text.m_7220_((Component)pathMode);
            } else {
                AIOTBase.setHoemode(stack, true);
                text = text.m_7220_((Component)hoeMode);
            }
            player.m_5661_((Component)text, true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    private static void setHoemode(ItemStack stack, boolean b) {
        stack.m_41784_().m_128379_("hoemode", b);
    }

    private static boolean isHoemode(ItemStack stack) {
        return stack.m_41619_() || !stack.m_41784_().m_128441_("hoemode") || stack.m_41784_().m_128471_("hoemode");
    }

    public int getBurnTime(@Nonnull ItemStack stack, @Nullable RecipeType<?> recipeType) {
        if (this.getToolMaterial() == AIOTMaterials.WOODEN) {
            return 400;
        }
        return 0;
    }
}

