/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.api;

import de.melanx.morevanillalib.api.IConfigurableTier;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.TierSortingRegistry;

public class ItemTier
implements IConfigurableTier {
    private final int durability;
    private final float efficiency;
    private final float attackDamage;
    private final float attackSpeed;
    private final int harvestLevel;
    private final int enchantmentValue;
    private final LazyValue<Ingredient> repairMaterial;
    private final LazyValue<Ingredient> craftingIngredient;
    private final String name;
    private final boolean vanilla;

    private ItemTier(int durability, float efficiency, float attackDamage, float attackSpeed, int harvestLevel, int enchantmentValue, LazyValue<Ingredient> repairMaterial, LazyValue<Ingredient> craftingIngredient, String name, boolean vanilla, boolean aiot, boolean big) {
        this.durability = aiot ? durability * 5 : (big ? durability * 7 : durability);
        this.efficiency = big ? efficiency / 3.5f : efficiency;
        this.attackDamage = attackDamage;
        this.attackSpeed = big ? attackSpeed : attackSpeed * 1.2f;
        this.harvestLevel = harvestLevel;
        this.enchantmentValue = enchantmentValue;
        this.repairMaterial = repairMaterial;
        this.craftingIngredient = craftingIngredient;
        this.name = name;
        this.vanilla = vanilla;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int m_6609_() {
        return this.durability;
    }

    @Override
    public float m_6624_() {
        return this.efficiency;
    }

    @Override
    public float m_6631_() {
        return this.attackDamage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public int m_6604_() {
        return this.harvestLevel;
    }

    @Override
    public int m_6601_() {
        return this.enchantmentValue;
    }

    @Override
    @Nonnull
    public Ingredient m_6282_() {
        return (Ingredient)this.repairMaterial.get();
    }

    @Override
    @Nonnull
    public Ingredient getCraftingIngredient() {
        return (Ingredient)this.craftingIngredient.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isVanilla() {
        return this.vanilla;
    }

    public static class Builder {
        private int durability = 1;
        private float speed;
        private float attackDamage;
        private float attackSpeed;
        private int harvestLevel;
        private int enchantmentValue;
        private Supplier<Ingredient> repairIngredient = () -> Ingredient.f_43901_;
        private Supplier<Ingredient> craftingIngredient = () -> Ingredient.f_43901_;
        private String name = "";
        private boolean vanilla;
        private boolean aiot;
        private boolean big;

        public Builder durability(int durability) {
            this.durability = durability;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder attackDamage(float attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        public Builder attackSpeed(float attackSpeed) {
            this.attackSpeed = attackSpeed;
            return this;
        }

        public Builder harvestLevel(int level) {
            this.harvestLevel = level;
            return this;
        }

        public Builder enchantmentValue(int enchantmentValue) {
            this.enchantmentValue = enchantmentValue;
            return this;
        }

        public Builder repairIngredient(Supplier<Ingredient> ingredient) {
            this.repairIngredient = ingredient;
            return this;
        }

        public Builder craftingIngredient(Supplier<Ingredient> ingredient) {
            this.craftingIngredient = ingredient;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder aiot() {
            this.aiot = true;
            return this;
        }

        public Builder big() {
            this.big = true;
            return this;
        }

        public Builder vanilla() {
            this.vanilla = true;
            return this;
        }

        public Builder copy() {
            Builder builder = new Builder();
            builder.durability = this.durability;
            builder.speed = this.speed;
            builder.attackDamage = this.attackDamage;
            builder.attackSpeed = this.attackSpeed;
            builder.harvestLevel = this.harvestLevel;
            builder.enchantmentValue = this.enchantmentValue;
            builder.repairIngredient = this.repairIngredient;
            builder.craftingIngredient = this.craftingIngredient;
            builder.name = this.name;
            builder.vanilla = this.vanilla;
            builder.aiot = this.aiot;
            builder.big = this.big;
            return builder;
        }

        public ItemTier build() {
            ItemTier tier = new ItemTier(this.durability, this.speed, this.attackDamage, this.attackSpeed, this.harvestLevel, this.enchantmentValue, (LazyValue<Ingredient>)new LazyValue(this.repairIngredient), (LazyValue<Ingredient>)new LazyValue(this.craftingIngredient), this.name, this.vanilla, this.aiot, this.big);
            if (!this.vanilla) {
                String name = this.name + (String)(this.big || this.aiot ? "_" + (this.aiot ? "aiot" : "big") : "");
                TierSortingRegistry.registerTier((Tier)tier, (ResourceLocation)new ResourceLocation("morevanillalib", name), List.of(), List.of());
            }
            return tier;
        }
    }
}

