/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.api;

import de.melanx.morevanillalib.api.IConfigurableTier;
import de.melanx.morevanillalib.api.ToolType;
import de.melanx.morevanillalib.api.normal.ToolMaterials;
import de.melanx.morevanillalib.config.FeatureConfig;
import de.melanx.morevanillalib.data.ModTags;
import de.melanx.morevanillalib.util.ComponentUtil;
import de.melanx.morevanillalib.util.ToolUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;

public class BaseToolItem
extends DiggerItem {
    protected final IConfigurableTier toolMaterial;
    protected final Set<ToolAction> toolActions;

    public BaseToolItem(IConfigurableTier tier, ToolType toolType, Item.Properties properties) {
        super(0.0f, tier.getAttackSpeed(), (Tier)tier, toolType.getBlocks(), properties);
        this.toolMaterial = tier;
        this.toolActions = toolType.getToolActions();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = super.m_6225_(context);
        for (ToolAction action : this.toolActions) {
            if (result != InteractionResult.PASS) break;
            result = ToolUtil.toolUse(context, action);
        }
        if (result != InteractionResult.PASS && !context.m_43725_().f_46443_ && ModTags.Items.PAPER_TOOLS.m_8110_((Object)this) && FeatureConfig.PaperDamage.enabled && context.m_43725_().f_46441_.nextDouble() < FeatureConfig.PaperDamage.chance) {
            ToolUtil.paperDamage((LivingEntity)context.m_43723_());
        }
        return result;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return this.toolActions.contains(toolAction);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean result = super.m_7579_(stack, target, attacker);
        if (!target.f_19853_.f_46443_ && ModTags.Items.PAPER_TOOLS.m_8110_((Object)this) && FeatureConfig.PaperDamage.enabled && target.f_19853_.f_46441_.nextDouble() < FeatureConfig.PaperDamage.chance) {
            ToolUtil.paperDamage(attacker);
        }
        return result;
    }

    public boolean m_6813_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entityLiving) {
        boolean result = super.m_6813_(stack, level, state, pos, entityLiving);
        if (!level.f_46443_ && state.m_60800_((BlockGetter)level, pos) != 0.0f && ModTags.Items.PAPER_TOOLS.m_8110_((Object)this) && FeatureConfig.PaperDamage.enabled && level.f_46441_.nextDouble() < FeatureConfig.PaperDamage.chance) {
            ToolUtil.paperDamage(entityLiving);
        }
        return result;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (FeatureConfig.vanillaOnly) {
            if (this.toolMaterial.isVanilla() || this.toolMaterial instanceof ToolMaterials) {
                super.m_6787_(group, items);
            }
        } else {
            super.m_6787_(group, items);
        }
    }

    public IConfigurableTier getToolMaterial() {
        return this.toolMaterial;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44980_ && ModTags.Items.SLIME_TOOLS.m_8110_((Object)stack.m_41720_())) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!this.toolMaterial.isVanilla() && FeatureConfig.vanillaOnly && !(this.toolMaterial instanceof ToolMaterials)) {
            tooltip.add((Component)ComponentUtil.getTooltip("disabled_item", new Object[0]).m_130940_(ChatFormatting.DARK_RED));
        } else if (Screen.m_96638_()) {
            tooltip.add((Component)ComponentUtil.getTooltip("durability", this.toolMaterial.m_6609_()).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)ComponentUtil.getTooltip("harvest_level", this.toolMaterial.m_6604_()).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)ComponentUtil.getTooltip("repairing_item", this.toolMaterial.m_6282_().m_43908_()[0].m_41720_().m_41466_().getString()).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)ComponentUtil.getTooltip("more_information", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }
}

