/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.data;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import li.cil.oc2.common.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public final class ModLootTableProvider
extends LootTableProvider {
    public ModLootTableProvider(DataGenerator generator) {
        super(generator);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
        map.forEach((location, table) -> LootTables.m_79202_((ValidationContext)context, (ResourceLocation)location, (LootTable)table));
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return Collections.singletonList(Pair.of(ModBlockLootTables::new, (Object)LootContextParamSets.f_81421_));
    }

    public static final class ModBlockLootTables
    extends BlockLoot {
        protected void addTables() {
            this.m_124288_((Block)Blocks.REDSTONE_INTERFACE.get());
            this.m_124288_((Block)Blocks.NETWORK_CONNECTOR.get());
            this.m_124288_((Block)Blocks.NETWORK_HUB.get());
            this.m_124288_((Block)Blocks.DISK_DRIVE.get());
            this.m_124288_((Block)Blocks.CHARGER.get());
            this.m_124175_((Block)Blocks.COMPUTER.get(), ModBlockLootTables::droppingWithInventory);
        }

        protected Iterable<Block> getKnownBlocks() {
            return StreamSupport.stream(super.getKnownBlocks().spliterator(), false).filter(block -> Objects.requireNonNull(block.getRegistryName()).m_135827_().equals("oc2")).filter(block -> block != Blocks.BUS_CABLE.get()).collect(Collectors.toList());
        }

        private static LootTable.Builder droppingWithInventory(Block block) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)ModBlockLootTables.m_124134_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("items", ModBlockLootTables.concat("BlockEntityTag", "items"), CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("energy", ModBlockLootTables.concat("BlockEntityTag", "energy"), CopyNbtFunction.MergeStrategy.REPLACE)))));
        }

        private static String concat(String ... paths) {
            return String.join((CharSequence)".", paths);
        }
    }
}

