/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.oc2.api.bus.device.vm.event.VMInitializationException;
import li.cil.oc2.api.bus.device.vm.event.VMInitializingEvent;
import li.cil.oc2.api.bus.device.vm.event.VMResumedRunningEvent;
import li.cil.oc2.api.bus.device.vm.event.VMSynchronizeEvent;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.RPCDeviceBusAdapter;
import li.cil.oc2.common.vm.AbstractVirtualMachine;
import li.cil.oc2.common.vm.context.global.GlobalVMContext;
import li.cil.sedna.riscv.R5Board;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class VMRunner
implements Runnable {
    private static final int TICKS_PER_SECOND = 20;
    private static final int TIMESLICE_IN_MS = 25;
    private static final ExecutorService VM_RUNNERS = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("VirtualMachine Runner");
        return thread;
    });
    private final R5Board board;
    private final GlobalVMContext context;
    private final RPCDeviceBusAdapter rpcAdapter;
    private final AtomicInteger timeQuotaInMillis = new AtomicInteger();
    private Future<?> lastSchedule;
    private boolean firedResumedRunningEvent;
    @Serialized
    private boolean firedInitializationEvent;
    @Serialized
    private Component runtimeError;
    @Serialized
    private long cycleLimit;
    @Serialized
    private long cycles;

    public VMRunner(AbstractVirtualMachine virtualMachine) {
        this.board = virtualMachine.state.board;
        this.context = virtualMachine.state.context;
        this.rpcAdapter = virtualMachine.state.rpcAdapter;
    }

    @Nullable
    public Component getRuntimeError() {
        return this.runtimeError;
    }

    public void tick() {
        boolean needsScheduling;
        this.rpcAdapter.tick();
        this.cycleLimit += (long)VMRunner.getCyclesPerTick();
        int timeQuota = this.timeQuotaInMillis.updateAndGet(x -> Math.min(x + 25, 25));
        boolean bl = needsScheduling = this.lastSchedule == null || this.lastSchedule.isDone() || this.lastSchedule.isCancelled();
        if (this.cycleLimit > 0L && timeQuota > 0 && needsScheduling) {
            this.lastSchedule = VM_RUNNERS.submit(this);
        }
    }

    public void join() {
        this.context.postEvent(new VMSynchronizeEvent());
        this.firedResumedRunningEvent = false;
        if (this.lastSchedule != null) {
            try {
                this.lastSchedule.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    @Override
    public void run() {
        do {
            long start = System.currentTimeMillis();
            int cycleBudget = VMRunner.getCyclesPerTick();
            int cyclesPerStep = 1000;
            int maxSteps = cycleBudget / 1000;
            this.handleBeforeRun();
            if (!this.board.isRunning()) break;
            for (int i = 0; i < maxSteps; ++i) {
                this.cycles += 1000L;
                this.board.step(1000);
                this.step(1000);
                if (System.currentTimeMillis() - start > (long)this.timeQuotaInMillis.get()) break;
            }
            this.handleAfterRun();
            int elapsed = (int)(System.currentTimeMillis() - start);
            this.timeQuotaInMillis.addAndGet(-elapsed);
        } while (this.cycles < this.cycleLimit && this.timeQuotaInMillis.get() > 0);
    }

    protected void handleBeforeRun() {
        if (!this.firedInitializationEvent) {
            this.firedInitializationEvent = true;
            try {
                this.context.postEvent(new VMInitializingEvent(this.board.getDefaultProgramStart()));
            }
            catch (VMInitializationException e) {
                this.board.setRunning(false);
                this.runtimeError = e.getErrorMessage().orElse((Component)new TranslatableComponent(Constants.COMPUTER_ERROR_UNKNOWN));
                return;
            }
        }
        if (!this.firedResumedRunningEvent) {
            this.firedResumedRunningEvent = true;
            this.context.postEvent(new VMResumedRunningEvent());
        }
    }

    protected void step(int cyclesPerStep) {
        this.rpcAdapter.step(cyclesPerStep);
    }

    protected void handleAfterRun() {
    }

    private static int getCyclesPerTick() {
        return 1250000;
    }
}

