/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.time.Duration;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import li.cil.oc2.common.util.LevelUtils;
import li.cil.oc2.common.util.Location;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;

public final class ThrottledSoundEmitter {
    private final Supplier<Optional<Location>> location;
    private final SoundEvent sound;
    private long minInterval;
    private SoundSource category;
    private float volume = 0.95f;
    private float volumeVariance = 0.05f;
    private float pitch = 0.9f;
    private float pitchVariance = 0.1f;
    private long lastEmittedTime;

    public ThrottledSoundEmitter(Supplier<Optional<Location>> location, SoundEvent sound) {
        this.location = location;
        this.sound = sound;
        this.category = SoundSource.BLOCKS;
        this.minInterval = 500L;
    }

    public void play() {
        long now = System.currentTimeMillis();
        if (now - this.lastEmittedTime > this.minInterval) {
            this.lastEmittedTime = now;
            this.location.get().ifPresent(location -> {
                LevelAccessor level = location.level();
                float volume = this.sampleVolume(level.m_5822_());
                float pitch = this.samplePitch(level.m_5822_());
                LevelUtils.playSound(level, location.pos(), this.sound, this.category, volume, pitch);
            });
        }
    }

    public ThrottledSoundEmitter withMinInterval(Duration minInterval) {
        this.minInterval = minInterval.toMillis();
        return this;
    }

    public ThrottledSoundEmitter withCategory(SoundSource category) {
        this.category = category;
        return this;
    }

    public ThrottledSoundEmitter withVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public ThrottledSoundEmitter withVolumeVariance(float volumeVariance) {
        this.volumeVariance = volumeVariance;
        return this;
    }

    public ThrottledSoundEmitter withPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public ThrottledSoundEmitter withPitchVariance(float pitchVariance) {
        this.pitchVariance = pitchVariance;
        return this;
    }

    private float sampleVolume(Random random) {
        return Mth.m_14036_((float)(this.volume + this.volumeVariance * (random.nextFloat() - 0.5f)), (float)0.0f, (float)1.0f);
    }

    private float samplePitch(Random random) {
        return Mth.m_14036_((float)(this.pitch + this.pitchVariance * (random.nextFloat() - 0.5f)), (float)0.0f, (float)1.0f);
    }
}

